package org.gcube.data.spd.irmng;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;


public class SynonimsCapabilityImpl implements SynonimsCapability {

	GCUBELog logger = new GCUBELog(SynonimsCapabilityImpl.class);

	@Override
	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}

	@Override
	public void getSynonimnsByIds(ObjectWriter<ResultItem> writer, String... ids) {
		ResultSet results = null;
		try{
			for (int i = 0; i < ids.length; i++) 	{
				//			logger.trace(ids[i]);
				results = getSynonimnsById(ids[i]); 	
				try {
					while(results.next()) {	
//						logger.trace("put in writer");
						createRIById(results.getString(1), writer);
					}
				} catch (SQLException e) {
					logger.error("sql Error",e);
				} finally{
					try {
						results.close();
					} catch (SQLException e) {
						logger.error("SQLException", e);
					}
				}
			}
		} finally{
			writer.close();
		}
	}


	/**
	 * Get all synonyms by id
	 */
	private ResultSet getSynonimnsById(String id) {
		logger.trace("getSynonimnsById " + id);

		ResultSet results = null;
		Database database = null;  

		try {
			database = new Database();  			
			database.connect();
			logger.trace("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'");
			results = database.get("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'");
		}		
		catch (Throwable e) {
			logger.error("general Error", e);
		}finally{
			database.shutDown();
		}
		return results;
	}

	/**
	 * Create Result Item synonym by id
	 */
	public void createRIById(String id, ObjectWriter<ResultItem> writer) {
		
		logger.trace("createRIById " + id);

		ResultSet results = null;
		Database database = null;  
		String ScName = "";
		String rank = "";
		String idParent = "";
		String citation = "";

		try {
			database = new Database();  			
			database.connect();
			//			taxonid, scientificname, scientificnameauthorship, genus, specificepithet, family, taxonrank, taxonomicstatus, nomenclaturalstatus, nameaccordingto, originalnameusageid, namepublishedin, acceptednameusageid, parentnameusage, parentnameusageid, taxonremarks, modified, nomenclaturalcode
			results = database.get("select scientificname, taxonrank, parentnameusageid, scientificnameauthorship from taxon where acceptednameusageid = '" + id + "'");

//					logger.trace("select scientificname, taxonrank, parentnameusageid, scientificnameauthorship from taxon where acceptednameusageid = '" + id + "'");

			while(results.next()) {	

				ScName = results.getString(1);
				rank = results.getString(2);
				idParent = results.getString(3);
				citation = results.getString(4);

				ResultItem item = new ResultItem(id, ScName);
				item.setCitation(citation);				
				item.setCredits(IrmngPlugin.credits);
				item.setRank(rank);

				DataSet dataSet = new DataSet("irmngid");
				dataSet.setName("IRMNG");
				DataProvider dp = new DataProvider("irmngid");
				dp.setName("IRMNG");
				dataSet.setDataProvider(dp);
				item.setDataSet(dataSet);
				//				logger.trace("idParent " + idParent);
				item.setParent(Utils.createTaxonomy(idParent));

				writer.put(item);

			}
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		}finally{
			try {
				results.close();
			} catch (SQLException e) {
				logger.error("general Error", e);
			}

			database.shutDown();
		}
	}

}
