package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.util.RepositoryInfo;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;


public class IrmngPlugin extends AbstractPlugin {

	private GCUBELog logger = new GCUBELog(IrmngPlugin.class);

	//Connection

	public static String jdbc;
	public static String user;
	public static String password;
	public static String dumpUrl;

//		public static String jdbc = "jdbc:postgresql://127.0.0.1:5432/IRMNG";
//		public static String user = "postgres";
//		public static String password = "";
//		public static String dumpUrl = "http://www.cmar.csiro.au/datacentre/downloads/IRMNG_DWC.zip";
		
	final static String credits = "IRMNG - Digital resource at http://www.obis.org.au/irmng/.";

	public static final String dumpDb = "/createIrmngDb.sql";

	@Override
	public void initialize(GCUBERuntimeResource res) throws Exception {
		for (AccessPoint ap:res.getAccessPoints()) {
			if (ap.getEntryname().equals("dump")) {
				dumpUrl = ap.getEndpoint();
			}
			else if (ap.getEntryname().equals("jdbc")) {
				jdbc = ap.getEndpoint();	
				user = ap.getUsername();
				password = ap.getPassword();			
			}
		}

		if (!(SQLTableExists("Taxon")) & !(SQLTableExists("SpeciesProfile")))
			new CreateDBThread();

		new UpdateThread();			
				super.initialize(res);
	}


	@Override
	public void update(GCUBERuntimeResource res) throws Exception {
		for (AccessPoint ap:res.getAccessPoints()) {
			if (ap.getEntryname().equals("dump")) {
				dumpUrl = ap.getEndpoint();
			}
			else if (ap.getEntryname().equals("jdbc")) {
				jdbc = ap.getEndpoint();	
				user = ap.getUsername();
				password = ap.getPassword();			
			}
		}
		super.update(res);
	}


	@Override
	public Set<SearchTypes> getSupportedSearch() {
		return Collections.singleton(SearchTypes.ScientificName);
	}


	@SuppressWarnings("serial")
	@Override
	public Set<Capabilities> getSupportedCapabilities() {
		return new HashSet<Capabilities>(){{add(Capabilities.Classification);}};
	}

	@Override
	public ClassificationCapability getClassificationInterface() {
		return new ClassificationCapabilityImpl();
	}

	@Override
	public void searchByCommonName(String commonName, ObjectWriter<ResultItem> writer, Property... properties) {

	}

	@Override
	public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property... properties) {

		logger.trace("searchByScientificName " + scientificName);

		ResultSet results = null;
		Database database = null;  
		String id = "";
		String rank = "";
		String idParent = "";
		String citation = "";

		try {
			database = new Database();  			
			database.connect();
			logger.trace("select taxonid, taxonrank, parentnameusageid, scientificnameauthorship, nameaccordingto from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");
			results = database.get("select taxonid, taxonrank, parentnameusageid, scientificnameauthorship, nameaccordingto from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");

			while(results.next()) {	

				id = results.getString(1);
				rank = results.getString(2);
				idParent = results.getString(3);
				citation = results.getString(4);

				ResultItem item = new ResultItem(id, Utils.setScName(id, rank));
				item.setCitation(citation);				
				item.setCredits(credits);
				item.setRank(rank);

				DataSet dataSet = new DataSet(results.getString(5));
				dataSet.setName(results.getString(5));
				dataSet.setCitation(results.getString(5));
				DataProvider dp = new DataProvider("irmngid");
				dp.setName("IRMNG");
				dataSet.setDataProvider(dp);
				item.setDataSet(dataSet);
				//				logger.trace("idParent " + idParent);
				item.setParent(Utils.createTaxonomy(idParent));

				writer.put(item);

			}
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		}finally{

			writer.close();	

			try {
				results.close();
			} catch (SQLException e) {
				logger.error("general Error", e);
			}

			database.shutDown();
		}

	}


	@Override
	public String getRepositoryName() {		
		return "IRMNG";
	}

	@Override
	public String getDescription() {
		return "Plugin for IRMNG";
	}


	/**
	 * Return true if a table exists
	 */
	protected boolean SQLTableExists(String tableName) {
		boolean exists = false;
		ResultSet rs = null;
		Database database = null;  
		try {
			database = new Database();  			
			database.connect();

			String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";    
			rs = database.get(sqlText);
			if (rs.next())
				exists = true;
			else
				exists = false;

		} catch (SQLException e) {
			logger.error("SQLException", e);
		}finally {

			try {
				if (rs != null) 
					rs.close();					
			} catch (SQLException e) {
				logger.error("SQLException", e);
			}

			database.shutDown();
		} 
		return exists;
	}



	@Override
	public RepositoryInfo getRepositoryInfo() {
		RepositoryInfo info = new RepositoryInfo("http://www.cmar.csiro.au/datacentre/irmng/irmng-small.gif", "http://www.cmar.csiro.au/datacentre/irmng/");
		return info;
	}
	

}
