/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.itis.ClassificationCapabilityImpl;
import org.gcube.data.spd.itis.Database;
import org.gcube.data.spd.itis.NamesMappingImpl;
import org.gcube.data.spd.itis.SynonimsCapabilityImpl;
import org.gcube.data.spd.itis.Utils;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ItisPlugin
extends AbstractPlugin {
    static GCUBELog logger = new GCUBELog(ItisPlugin.class);
    public static String hostName;
    public static String jdbc;
    public static String user;
    public static String password;
    public static String baseurl;

    public void initialize(GCUBERuntimeResource res) throws Exception {
        for (AccessPoint ap : res.getAccessPoints()) {
            if (!ap.getEntryname().equals("jdbc")) continue;
            jdbc = ap.getEndpoint();
            user = ap.getUsername();
            password = ap.getPassword();
            hostName = ap.getProperty("hostName");
        }
    }

    public void update(GCUBERuntimeResource res) throws Exception {
        for (AccessPoint ap : res.getAccessPoints()) {
            if (!ap.getEntryname().equals("jdbc")) continue;
            jdbc = ap.getEndpoint();
            user = ap.getUsername();
            password = ap.getPassword();
            hostName = ap.getProperty("hostName");
        }
    }

    public void shutdown() throws Exception {
    }

    public String getDescription() {
        return "Interagency Taxonomic Information System (ITIS) Plugin";
    }

    public String getRepositoryName() {
        return "ITIS";
    }

    public Set<SearchTypes> getSupportedSearch() {
        return new HashSet<SearchTypes>(){
            {
                this.add(SearchTypes.ScientificName);
                this.add(SearchTypes.CommonName);
            }
        };
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.NamesMapping);
                this.add(Capabilities.Classification);
                this.add(Capabilities.Synonims);
            }
        };
    }

    public NamesMappingCapability getNamesMappingInterface() {
        return new NamesMappingImpl();
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public SynonimsCapability getSynonimsInterface() {
        return new SynonimsCapabilityImpl();
    }

    public void searchByCommonName(String commonName, ObjectWriter<ResultItem> writer, Property ... properties) {
        logger.trace((Object)("searchByCommonName " + commonName));
        ResultSet rs = null;
        Utils util = new Utils();
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    rs = database.get("select a.tsn from vernaculars as a join taxonomic_units as b on a.tsn = b.tsn where UPPER(vernacular_name) like UPPER('%" + commonName + "%') and b.unaccept_reason =''");
                    while (rs.next()) {
                        String id = rs.getString(1);
                        util.search(id, writer, "common name");
                    }
                    logger.trace((Object)("searchByCommonName finished for " + commonName + " in ITIS"));
                }
                catch (SQLException e) {
                    logger.error((Object)"SQL Error", (Throwable)e);
                    writer.close();
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            logger.error((Object)"SQL Error", (Throwable)e2);
                        }
                    }
                    database.shutDown();
                }
            }
            finally {
                writer.close();
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"SQL Error", (Throwable)e);
                    }
                }
                database.shutDown();
            }
        } else {
            logger.error((Object)"No connection");
        }
    }

    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... properties) {
        Utils util = new Utils();
        logger.trace((Object)("searchByScientificName " + scientificName));
        try {
            try {
                util.search(scientificName, writer, "scientific name");
            }
            catch (Exception e) {
                logger.error((Object)"General Error", (Throwable)e);
                writer.close();
                logger.trace((Object)("searchByScientificName finished for " + scientificName + " in ITIS"));
            }
        }
        finally {
            writer.close();
            logger.trace((Object)("searchByScientificName finished for " + scientificName + " in ITIS"));
        }
    }
}

