/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.itis.dbconnection.ConnectionPool;
import org.gcube.data.spd.itis.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.CommonName;

public class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);
    static final String citation = "Accessed through: the Integrated Taxonomic Information System (ITIS) at http://www.itis.gov on ";
    static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with ITIS, the Integrated Taxonomic Information System (http://www.itis.gov/)";

    public static String getCitationItis() {
        StringBuilder cit = new StringBuilder();
        cit.append(citation);
        cit.append(Utils.getDateItis());
        return cit.toString();
    }

    public static String getCreditsItis() {
        String cred = credits.replace("XDATEX", Utils.getDateItis());
        return cred;
    }

    private static String getDateItis() {
        String date = null;
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("MM-dd-yyyy");
        date = format.format(now.getTime());
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInfoFromId(String id, String type) {
        String info;
        block25: {
            info = null;
            ConnectionPool pool = null;
            Connection con = null;
            ResultSet res = null;
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                String query = null;
                if (type.equals("author")) {
                    query = "select taxon_author from taxon_authors_lkp where taxon_author_id = ?";
                } else if (type.equals("rank")) {
                    query = "select rank_name from taxon_unit_types where rank_id = ?";
                }
                if (query != null) {
                    res = pool.selectPrestatement(query, id);
                }
                if (res != null) {
                    if (res.next()) {
                        info = res.getString(1);
                    }
                    break block25;
                }
                String string = "";
                return string;
            }
            catch (SQLException e) {
                logger.error((Object)"SQL Error", (Throwable)e);
            }
            catch (ConnectionPoolException e) {
                logger.error((Object)"ConnectionPoolException", (Throwable)e);
            }
            finally {
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
                try {
                    if (res != null) {
                        res.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CommonName> getCommonNameFromId(String id) {
        ArrayList<CommonName> commonNames = null;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select vernacular_name, language from vernaculars where tsn = ?";
            results = pool.selectPrestatement(query, id);
            if (results != null) {
                commonNames = new ArrayList<CommonName>();
                while (results.next()) {
                    String name = results.getString(1);
                    String language = results.getString(2);
                    CommonName commonName = new CommonName(language, name);
                    commonNames.add(commonName);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Error", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"SQL Error", (Throwable)ex);
            }
        }
        return commonNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
            results = statement.executeQuery(sqlText);
            if (results.next()) {
                logger.trace((Object)(tableName + " already exists"));
                exists = true;
            } else {
                logger.trace((Object)(tableName + " does not exists"));
                exists = false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        logger.trace((Object)exists);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        long nextUpdate = 0L;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String query = "select date from updates where id = (select max(id) from updates)";
            results = statement.executeQuery(query);
            java.sql.Date lastUpdate = null;
            if (results.next()) {
                lastUpdate = results.getDate(1);
                Date date = new Date();
                long days = date.getTime() - lastUpdate.getTime();
                if (days < 2592000000L) {
                    long l = 2592000000L - days;
                    return l;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return nextUpdate;
    }
}

