/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis;

import java.security.Key;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.spd.itis.UpdateThread;
import org.gcube.data.spd.itis.Utils;
import org.gcube.data.spd.itis.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.itis.capabilities.ExpansionCapabilityImpl;
import org.gcube.data.spd.itis.capabilities.NamesMappingImpl;
import org.gcube.data.spd.itis.dbconnection.ConnectionPool;
import org.gcube.data.spd.itis.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.ExpansionCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ItisPlugin
extends AbstractPlugin {
    static GCUBELog logger = new GCUBELog(ItisPlugin.class);
    public static String hostName;
    public static String jdbc;
    public static String user;
    public static String password;
    static final String urlDump = "http://www.itis.gov/downloads/itisMySQLTables.tar.gz";
    public static String baseurl;
    public static final String driver = "com.mysql.jdbc.Driver";
    static final String zipFileName = "itisMySQLTables.tar.gz";
    static final String fileDump = "dropcreateloaditis.sql";

    public void initialize(ServiceEndpoint res) throws Exception {
        try {
            block4: for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
                if (!ap.name().equals("jdbc")) continue;
                jdbc = ap.address();
                user = ap.username();
                password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                for (ServiceEndpoint.Property p : ap.properties()) {
                    if (!p.name().equals("hostName")) continue;
                    hostName = p.toString();
                    continue block4;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in inizialize", (Throwable)e);
        }
        try {
            if (!Utils.SQLTableExists("updates")) {
                new UpdateThread(0L);
            } else {
                long update = Utils.lastupdate();
                new UpdateThread(update);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error during update", (Throwable)e);
        }
        super.initialize(res);
    }

    public void update(ServiceEndpoint res) throws Exception {
        block0: for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            user = ap.username();
            password = ap.password();
            for (ServiceEndpoint.Property p : ap.properties()) {
                if (!p.equals((Object)"hostName")) continue;
                hostName = p.toString();
                continue block0;
            }
        }
        super.update(res);
    }

    public String getDescription() {
        return "Interagency Taxonomic Information System (ITIS) Plugin";
    }

    public String getRepositoryName() {
        return "ITIS";
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.NamesMapping);
                this.add(Capabilities.Classification);
                this.add(Capabilities.Expansion);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public ExpansionCapability getExpansionInterface() {
        return new ExpansionCapabilityImpl();
    }

    public MappingCapability getMappingInterface() {
        return new NamesMappingImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Condition ... properties) {
        ResultSet rs = null;
        try {
            ConnectionPool pool = null;
            Connection con = null;
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                String query = "select a.tsn, a.completename from longnames as a join taxonomic_units as b on a.tsn = b.tsn where UPPER(a.completename) like UPPER(?)";
                rs = pool.selectPrestatement(query, "%" + scientificName + "%");
            }
            catch (ConnectionPoolException e) {
                logger.error((Object)"ConnectionPoolException", (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)"SQL Error", (Throwable)e);
            }
            finally {
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
            if (rs != null) {
                while (rs.next()) {
                    String tsn = rs.getString(1);
                    String completeName = rs.getString(2);
                    this.searchByTsn(tsn, writer, completeName, "scientific name", null);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Error", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException Error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"SQL Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByTsn(String tsn, ObjectWriter<ResultItem> writer, String completeName, String type, String id) throws ConnectionPoolException {
        block29: {
            ResultSet rs2 = null;
            ConnectionPool pool = null;
            Connection con = null;
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                String query = "select a.source, a.version, a.source_id from other_sources as a join reference_links as b on b.doc_id_prefix = a.source_id_prefix and b.documentation_id = a.source_id and b.tsn = ?";
                rs2 = pool.selectPrestatement(query, tsn);
                if (rs2 == null) break block29;
                while (rs2.next()) {
                    String source = rs2.getString(1);
                    String version = rs2.getString(2);
                    String id_source = rs2.getString(3);
                    ResultItem ri = new ResultItem(tsn, completeName);
                    DataSet dataSet = new DataSet(id_source);
                    dataSet.setName(source + " " + version);
                    DataProvider dp = new DataProvider("ITIS");
                    dp.setName("The Integrated Taxonomic Information System (ITIS)");
                    dataSet.setDataProvider(dp);
                    ri.setDataSet(dataSet);
                    List<CommonName> commonNames = Utils.getCommonNameFromId(tsn);
                    ri.setCommonNames(commonNames);
                    commonNames.clear();
                    ri.setLsid("urn:lsid:itis.gov:itis_tsn:" + tsn);
                    ri.setCitation(Utils.getCitationItis());
                    ri.setCredits(Utils.getCitationItis());
                    ResultSet rs = null;
                    try {
                        String query1;
                        pool = ConnectionPool.getConnectionPool();
                        con = pool.getConnection();
                        Taxon hierarchy = null;
                        if (type.equals("synonym")) {
                            hierarchy = this.getHierarchyFromId(id, pool, con);
                            ri.setParent(hierarchy);
                            query1 = "select taxon_author_id, rank_id from taxonomic_units where tsn = ?";
                            rs = pool.selectPrestatement(query1, id);
                        } else {
                            hierarchy = this.getHierarchyFromId(tsn, pool, con);
                            ri.setParent(hierarchy);
                            query1 = "select taxon_author_id, rank_id from taxonomic_units where tsn = ?";
                            rs = pool.selectPrestatement(query1, tsn);
                        }
                        if (rs != null && rs.next()) {
                            ri.setAuthor(Utils.getInfoFromId(rs.getString(1), "author"));
                            ri.setRank(Utils.getInfoFromId(rs.getString(2), "rank"));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error retrieving author and rank", (Throwable)e);
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"SQL Error", (Throwable)ex);
                        }
                    }
                    writer.write((Object)ri);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQL Error", (Throwable)e);
            }
            finally {
                try {
                    if (rs2 != null) {
                        rs2.close();
                    }
                    if (pool != null && con != null) {
                        pool.releaseConnection(con);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taxon getHierarchyFromId(String id, ConnectionPool pool, Connection con) {
        Taxon b = null;
        ResultSet rs = null;
        try {
            String query;
            if (pool == null) {
                pool = ConnectionPool.getConnectionPool();
            }
            if (con == null) {
                con = pool.getConnection();
            }
            if ((rs = pool.selectPrestatement(query = "select a.parent_tsn, b.unit_name1, b.unit_name2, b.unit_name3, b.unit_name4, b.taxon_author_id, b.rank_id from taxonomic_units as a join taxonomic_units as b on a.parent_tsn = b.tsn and a.tsn = ?", id)).next()) {
                String parent_id = rs.getString(1);
                String rank_id = rs.getString(7);
                String citation_id = rs.getString(6);
                if (!rs.getString(2).equals("")) {
                    String sName = rs.getString(2);
                    if (!rs.getString(3).equals("")) {
                        sName = sName.concat(" " + rs.getString(3));
                        if (!rs.getString(4).equals("")) {
                            sName = sName.concat(" " + rs.getString(4));
                            if (!rs.getString(5).equals("")) {
                                sName = sName.concat(" " + rs.getString(5));
                            }
                        }
                    }
                    b = new Taxon(parent_id);
                    b.setLsid("urn:lsid:itis.gov:itis_tsn:" + parent_id);
                    if (!rank_id.equals("0")) {
                        b.setRank(Utils.getInfoFromId(rank_id, "rank"));
                    }
                    if (!citation_id.equals("0")) {
                        b.setCitation(Utils.getInfoFromId(citation_id, "author"));
                    }
                    b.setScientificName(sName);
                    if (!parent_id.equals("0")) {
                        b.setParent(this.getHierarchyFromId(parent_id, pool, con));
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Error", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"SQL Error", (Throwable)ex);
            }
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return b;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://www.catalogueoflife.org/prototype/images/logos/itis.jpg", "http://www.itis.gov/", "ITIS provides access to a database with reliable information on species names and their hierarchical classification. The database is reviewed periodically to ensure high quality with valid classifications, revisions, and additions of newly described species. The ITIS database includes documented taxonomic information of flora and fauna from both aquatic and terrestrial habitats.  ITIS is a partnership of U.S., Canadian, and Mexican agencies (ITIS-North America); other organizations; and taxonomic specialists. ITIS is also a partner of Species 2000 and the Global Biodiversity Information Facility (GBIF). The ITIS and Species 2000 Catalogue of Life (CoL) partnership is proud to provide the taxonomic backbone to the Encyclopedia of Life (EOL).");
        return info;
    }

    static {
        baseurl = "http://www.itis.gov/ITISWebService/services/ITISService";
    }
}

