/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.UpdateThread;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.ncbi.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.ncbi.capabilities.NamesMappingImpl;
import org.gcube.data.spd.ncbi.capabilities.SynonimsCapabilityImpl;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class NcbiPlugin
extends AbstractPlugin {
    static GCUBELog logger = new GCUBELog(NcbiPlugin.class);
    public static String jdbc;
    public static String username;
    public static String password;
    public static Hashtable<String, String> tables;
    public static final String credits = "GenBank taxonomy database";
    static final String urlDump = "ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz";
    static final String zipFileName = "taxdump.tar.gz";
    static final String fileDump = "/ncbi_db.sql";
    static final String[] names;

    public void initialize(GCUBERuntimeResource res) throws Exception {
        String s;
        for (AccessPoint ap : res.getAccessPoints()) {
        }
        Boolean flag = false;
        int i$ = 0;
        String[] arr$ = names;
        int len$ = arr$.length;
        if (i$ < len$ && !NcbiPlugin.SQLTableExists(s = arr$[i$])) {
            flag = true;
        }
        if (flag.booleanValue()) {
            Utils.createDB();
        }
        new UpdateThread();
    }

    public String getDescription() {
        return "NCBI Plugin";
    }

    public String getRepositoryName() {
        return "NCBI";
    }

    public Set<SearchTypes> getSupportedSearch() {
        return new HashSet<SearchTypes>(){
            {
                this.add(SearchTypes.ScientificName);
                this.add(SearchTypes.CommonName);
            }
        };
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.Synonims);
                this.add(Capabilities.NamesMapping);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public SynonimsCapability getSynonimsInterface() {
        return new SynonimsCapabilityImpl();
    }

    public NamesMappingCapability getNamesMappingInterface() {
        return new NamesMappingImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByCommonName(String commonName, ObjectWriter<ResultItem> writer, Property ... arg2) {
        logger.trace((Object)("searchByCommonName for " + commonName + " in NCBI..."));
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs1 = database.get("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + commonName + "%')");
            while (rs1.next()) {
                int id = rs1.getInt(1);
                rs2 = database.get("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id);
                if (!rs2.next()) continue;
                String ScName = rs2.getString(1);
                logger.trace((Object)ScName);
                String rank = rs2.getString(2);
                String idParent = rs2.getString(3);
                ResultItem rs = new ResultItem(Integer.toString(id), ScName);
                rs.setCommonNames(Utils.getCommonNames(id));
                rs.setCredits(credits);
                if (rank.equals("no rank")) {
                    rs.setRank(null);
                } else {
                    rs.setRank(rank);
                }
                rs.setCitation(Utils.getCitation(Integer.parseInt(idParent)));
                DataSet dataSet = new DataSet("GenBank");
                dataSet.setName(credits);
                DataProvider dp = new DataProvider("GenBank");
                dp.setName(credits);
                dataSet.setDataProvider(dp);
                rs.setDataSet(dataSet);
                if (!idParent.equals("1")) {
                    rs.setParent(Utils.findTax(Integer.parseInt(idParent)));
                }
                writer.put((Object)rs);
            }
            logger.trace((Object)("searchByCommonName finished for " + commonName + " in NCBI"));
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            logger.trace((Object)"close");
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
            catch (Exception e) {
                logger.error((Object)"General Error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... properties) {
        logger.trace((Object)("searchByScientificName for " + scientificName + " in NCBI..."));
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs1 = database.get("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + scientificName + "%')");
            while (rs1.next()) {
                int id = rs1.getInt(1);
                rs2 = database.get("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id);
                if (!rs2.next()) continue;
                String ScName = rs2.getString(1);
                logger.trace((Object)ScName);
                String rank = rs2.getString(2);
                String idParent = rs2.getString(3);
                ResultItem rs = new ResultItem(Integer.toString(id), ScName);
                rs.setCommonNames(Utils.getCommonNames(id));
                rs.setCredits(credits);
                if (rank.equals("no rank")) {
                    rs.setRank(null);
                } else {
                    rs.setRank(rank);
                }
                rs.setCitation(Utils.getCitation(Integer.parseInt(idParent)));
                DataSet dataSet = new DataSet("GenBank");
                dataSet.setName(credits);
                DataProvider dp = new DataProvider("GenBank");
                dp.setName(credits);
                dataSet.setDataProvider(dp);
                rs.setDataSet(dataSet);
                if (!idParent.equals("1")) {
                    rs.setParent(Utils.findTax(Integer.parseInt(idParent)));
                }
                writer.put((Object)rs);
            }
            logger.trace((Object)("searchByCommonName finished for " + scientificName + " in NCBI"));
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            logger.trace((Object)"close");
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                this.shutdown();
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
            catch (Exception e) {
                logger.error((Object)"General Error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
            rs = database.get(sqlText);
            exists = rs.next();
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return exists;
    }

    static {
        tables = new Hashtable();
        names = new String[]{"nodes", "delnodes", "merged", "citations", "names", "division", "gencode"};
    }
}

