package org.gcube.data.spd.ncbi.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.NcbiPlugin;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;


public class SynonimsCapabilityImpl implements SynonimsCapability {

	private static GCUBELog logger = new GCUBELog(SynonimsCapabilityImpl.class);

	@Override
	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}

	@Override
	public void getSynonimnsByIds(ObjectWriter<ResultItem> writer, String... ids) {

		logger.trace("getSynonimnsByIds in NCBI...");
		ResultSet rs = null;
		
		for (String id: ids){

			Database database = null;  
			try {
				database = new Database();  			
				database.connect();
//				logger.trace("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'synonym' and a.tax_id = " + id  );
				rs = database.get("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'synonym' and a.tax_id = " + id  );

				while(rs.next()) {					
					String ScName = rs.getString(1);
//					logger.trace(ScName);
					String rank = rs.getString(2);
					String idParent = rs.getString(3);

					ResultItem ri = new ResultItem(id, ScName);

					ri.setCommonNames(Utils.getCommonNames(Integer.parseInt(id)));

					ri.setCredits(NcbiPlugin.credits);
					if (rank.equals("no rank"))
						ri.setRank(null);
					else					
						ri.setRank(rank);

					ri.setCitation(Utils.getCitation(Integer.parseInt(idParent)));

					DataSet dataSet = new DataSet("GenBank");
					dataSet.setName("GenBank taxonomy database");
					DataProvider dp = new DataProvider("GenBank");
					dp.setName("GenBank taxonomy database");
					dataSet.setDataProvider(dp);
					ri.setDataSet(dataSet);

					if (!(idParent.equals("1")))
						ri.setParent(Utils.findTax(Integer.parseInt(idParent)));	            	      	

					writer.put(ri);
				}
			}			
			catch (SQLException sqlExcept) {
				logger.error("sql Error", sqlExcept);
			}catch (Throwable e) {
				logger.error("general Error", e);
			} finally {
				writer.close();
				try {										
					if (rs != null) 
						rs.close();
					try {
						database.shutDown();
					} catch (Exception e) {
						logger.error("General Error", e);
					}

				} catch (SQLException ex) {
					logger.error("sql Error", ex);

				}
			}

			
			
		}
		logger.trace("getSynonimnsByIds finished in NCBI");
	}

}
