/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.NcbiPlugin;

class UpdateThread
extends Thread {
    static GCUBELog logger = new GCUBELog(UpdateThread.class);

    UpdateThread() {
        this.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        this.update();
                        UpdateThread.sleep(2592000000L);
                    }
                }
                catch (InterruptedException e) {
                    logger.error((Object)"InterruptedException", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.error((Object)"IOException", (Throwable)e);
            return;
        }
    }

    protected void update() throws IOException {
        try {
            URL url = new URL(NcbiPlugin.urlDump);
            File tempFolder = File.createTempFile("ncbi-folder", "");
            tempFolder.delete();
            tempFolder.mkdir();
            if (this.downloadFromUrl(url, tempFolder + "/" + "taxdump.tar.gz")) {
                Runtime rt1 = Runtime.getRuntime();
                Process runtimeProcess1 = null;
                logger.trace((Object)("tar xzvf " + tempFolder + "/" + "taxdump.tar.gz" + " -C " + tempFolder));
                runtimeProcess1 = rt1.exec("tar xzvf " + tempFolder + "/" + "taxdump.tar.gz" + " -C " + tempFolder);
                runtimeProcess1.waitFor();
                this.importData(tempFolder);
                this.clearTmp(tempFolder);
                this.createTableCit();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error Downloading Dump", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableCit() {
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select cit_id, taxid_list from citations");
            while (rs.next()) {
                String[] list;
                int cit_id = rs.getInt(1);
                String taxid_list = rs.getString(2);
                if (taxid_list == null) continue;
                for (String tax_id : list = taxid_list.split(" ")) {
                    database.update("insert into citation(tax_id, cit_id) values (" + tax_id + ", " + cit_id + ")");
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"Can't create citation table", (Throwable)ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
            rs = database.get(sqlText);
            exists = rs.next();
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException in SQLTableExists", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException", (Throwable)e);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFromUrl(URL url, String localFilename) {
        Boolean flag = false;
        logger.trace((Object)("Downloading from " + url + " ..."));
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(localFilename);
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            logger.trace((Object)"Download completed successfully");
            flag = true;
        }
        catch (IOException e) {
            logger.error((Object)"Error, check url", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"IOException Error", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Object)"IOException Error", (Throwable)e);
                }
            }
        }
        return flag;
    }

    private void clearTmp(File f) {
        if (f.exists()) {
            for (File c : f.listFiles()) {
                if (c.isDirectory()) {
                    this.clearTmp(c);
                }
                c.delete();
            }
            f.delete();
        }
        logger.trace((Object)"Deleted files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData(File tempFolder) throws SQLException, IOException {
        Hashtable<String, String> tables = new Hashtable<String, String>();
        tables.put("nodes", "create table nodes(tax_id integer NOT NULL PRIMARY KEY,parent_tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE, rank varchar(128),embl_code varchar(64),division_id integer,inherited_div_flag boolean,genetic_code_id integer, inherited_GC_flag boolean,mitochondrial_genetic_code_id integer,inherited_MGC_flag boolean,GenBank_hidden_flag boolean,hidden_subtree_root_flag boolean,comments varchar)");
        tables.put("delnodes", "create table delnodes(tax_id integer)");
        tables.put("merged", "create table merged(old_tax_id integer,new_tax_id integer)");
        tables.put("citations", "create table citations(cit_id integer NOT NULL PRIMARY KEY,cit_key varchar(255),pubmed_id integer default 0,medline_id integer default 0,url text,text text,taxid_list varchar)");
        tables.put("names", "create table names(tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE,name_txt text,unique_name varchar(255),name_class varchar(128))");
        tables.put("division", "create table division(division_id integer NOT NULL PRIMARY KEY,division_code varchar(4),division_name varchar(64),comments varchar)");
        tables.put("gencode", "create table gencode(genetic_code_id integer NOT NULL PRIMARY KEY,abbreviation varchar(64),name text,cde text,starts varchar(255))");
        tables.put("citation", "create table citation(tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE, cit_id integer NOT NULL references citations(cit_id) ON DELETE CASCADE)");
        if (tempFolder.isDirectory()) {
            logger.trace((Object)"Starting import from:");
            for (String n : NcbiPlugin.names) {
                File f = new File(tempFolder + "/" + n + ".dmp");
                if (!f.getName().toLowerCase().endsWith("dmp")) continue;
                String table = null;
                int index = f.getName().lastIndexOf(46);
                if (index > 0 && index <= f.getName().length() - 2) {
                    table = f.getName().substring(0, index);
                }
                this.getFileContent(tempFolder, f.getPath(), table);
                File tab = new File(tempFolder + "/" + table);
                Database database = null;
                try {
                    database = new Database();
                    database.connect();
                    if (this.SQLTableExists(table)) {
                        logger.trace((Object)("drop table " + table + " cascade"));
                        database.update("drop table " + table + " cascade");
                    }
                    database.update((String)tables.get(table));
                    logger.trace(tables.get(table));
                    database.copy("copy " + table + " from stdin DELIMITERS '\t' CSV", tab.getAbsolutePath());
                    logger.trace((Object)f.getName());
                }
                finally {
                    database.shutDown();
                }
            }
            logger.trace((Object)"Import completed successfully!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileContent(File tempFolder, String path, String output) throws FileNotFoundException, IOException {
        logger.trace((Object)("getContent " + path + " " + output));
        BufferedWriter bw = new BufferedWriter(new FileWriter(tempFolder + "/" + output));
        FileInputStream in = new FileInputStream(path);
        InputStreamReader r = new InputStreamReader(in);
        StringBuilder line = new StringBuilder();
        Integer count = 0;
        Integer tab = 0;
        Integer quot = 0;
        int before = 0;
        ResultSet rs = null;
        Database database = null;
        try {
            int intch;
            database = new Database();
            database.connect();
            logger.trace((Object)("select * from " + output + " LIMIT 1"));
            rs = database.get("select * from " + output + " LIMIT 1");
            ResultSetMetaData rsmd = rs.getMetaData();
            tab = rsmd.getColumnCount();
            while ((intch = ((Reader)r).read()) != -1) {
                Integer n;
                Integer n2;
                char ch = (char)intch;
                if (ch == '|' & before == 9) {
                    n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    if (count == tab) {
                        if (quot != 0 & quot % 2 != 0) {
                            String new_line = line.toString().replace("\"", "");
                            bw.write(new_line.toString());
                        } else {
                            bw.write(line.toString());
                        }
                        bw.write(10);
                        line.delete(0, line.length());
                        count = 0;
                        quot = 0;
                    } else {
                        line.append('\t');
                    }
                } else if (ch != '|' & ch != '\n' & ch != '\t') {
                    line.append(ch);
                    if (ch == '\"') {
                        n2 = quot;
                        n = quot = Integer.valueOf(quot + 1);
                    }
                }
                before = ch;
            }
            bw.close();
            ((InputStream)in).close();
            ((Reader)r).close();
        }
        catch (SQLException e) {
            logger.error((Object)"sql Error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }
}

