/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonymnsByIds(ObjectWriter<TaxonomyItem> writer, String ... ids) throws MethodNotSupportedException {
        this.logger.trace((Object)"getSynonimnsByIds in NCBI...");
        ResultSet rs = null;
        for (String id : ids) {
            Database database = null;
            try {
                database = new Database();
                database.connect();
                rs = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'synonym' and a.tax_id = " + id);
                while (rs.next()) {
                    TaxonomyItem item = this.createTaxonomyItem(rs);
                    writer.put((Object)item);
                }
            }
            catch (SQLException sqlExcept) {
                this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
            }
            catch (Throwable e) {
                this.logger.error((Object)"general Error", e);
            }
            finally {
                writer.close();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    try {
                        database.shutDown();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"General Error", (Throwable)e);
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
        this.logger.trace((Object)"getSynonimnsByIds finished in NCBI");
    }

    private TaxonomyItem createTaxonomyItem(ResultSet rs) throws SQLException {
        String id = rs.getString(1);
        String ScName = rs.getString(2);
        String rank = rs.getString(3);
        String idParent = rs.getString(4);
        String status = rs.getString(5);
        TaxonomyItem item = new TaxonomyItem(id);
        item.setScientificName(ScName);
        item.setCommonNames(Utils.getCommonNames(Integer.parseInt(id)));
        item.setStatus(this.setTaxonomicStatus(status));
        item.setCredits("GenBank taxonomy database");
        if (!rank.equals("no rank")) {
            item.setRank(rank);
        }
        item.setAuthor(Utils.getCitation(Integer.parseInt(id)));
        if (!idParent.equals("1") && !rank.equals("kingdom")) {
            item.setParent(this.createTaxItemById(Integer.parseInt(idParent)));
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id) {
        this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id));
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            this.logger.trace((Object)("select  a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id));
            rs = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id);
            while (rs.next()) {
                TaxonomyItem tax = this.createTaxonomyItem(rs);
                list.add(tax);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
            catch (Exception e) {
                this.logger.error((Object)"General Error", (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        this.logger.trace((Object)("Retrive Taxa By Common Name " + name));
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + name + "%')");
            while (rs.next()) {
                int id = rs.getInt(1);
                TaxonomyItem item = this.createTaxItemById(id);
                writer.put((Object)item);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        this.logger.trace((Object)("Retrive Taxa By Scientific Name " + name));
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + name + "%')");
            while (rs.next()) {
                int id = rs.getInt(1);
                TaxonomyItem item = this.createTaxItemById(id);
                writer.put((Object)item);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyItem createTaxItemById(int id) {
        ResultSet rs = null;
        TaxonomyItem item = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id);
            if (rs.next()) {
                item = this.createTaxonomyItem(rs);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
        try {
            while (ids.hasNext()) {
                String id = ids.next();
                this.logger.trace((Object)("Retrive taxon by id " + id));
                TaxonomyItem item = this.createTaxItemById(Integer.parseInt(id));
                writer.put((Object)item);
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
        }
    }

    private TaxonomyStatus setTaxonomicStatus(String status) {
        TaxonomyStatus tax = status.equals("scientific name") ? new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED, status) : new TaxonomyStatus(TaxonomyStatus.Status.UNKNOWN, status);
        return tax;
    }
}

