/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ObisClassification
extends ClassificationCapability {
    protected Logger logger = Logger.getLogger(ObisClassification.class);
    protected PluginSessionPool sessionPool;

    public ObisClassification(PluginSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public void searchByCommonName(String word, final ObjectWriter<TaxonomyItem> writer, Property ... properties) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            try {
                ObisClient.getTaxonByCommonName(session, word, new Writer<TaxonomyItem>(){

                    @Override
                    public void write(TaxonomyItem item) {
                        writer.put((Object)item);
                    }
                });
            }
            catch (Exception e) {
                this.logger.error((Object)"Error retrieving taxon", (Throwable)e);
                writer.close();
                this.sessionPool.checkIn(session);
            }
        }
        finally {
            writer.close();
            this.sessionPool.checkIn(session);
        }
    }

    public void searchByScientificName(String word, final ObjectWriter<TaxonomyItem> writer, Property ... properties) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            try {
                ObisClient.getTaxonByScientificNames(session, word, new Writer<TaxonomyItem>(){

                    @Override
                    public void write(TaxonomyItem item) {
                        writer.put((Object)item);
                    }
                });
            }
            catch (Exception e) {
                this.logger.error((Object)("Error retrieving taxon with word \"" + word + "\""), (Throwable)e);
                writer.close();
                this.sessionPool.checkIn(session);
            }
        }
        finally {
            writer.close();
            this.sessionPool.checkIn(session);
        }
    }

    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String taxonId) throws IdNotValidException {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            int id = this.converId(taxonId);
            List<TaxonomyItem> list = ObisClient.getChildrenTaxon(session, id);
            return list;
        }
        catch (SQLException e) {
            this.logger.error((Object)"Error retrieving TaxonChildsByTaxonId", (Throwable)e);
            return null;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void retrieveTaxonByIds(Iterator<String> reader, ObjectWriter<TaxonomyItem> writer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TaxonomyItem retrieveTaxonById(String taxonId) throws IdNotValidException {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            TaxonomyItem item;
            int id = this.converId(taxonId);
            TaxonomyItem taxonomyItem = item = ObisClient.getTaxonById(session, id);
            return taxonomyItem;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving TaxonById", (Throwable)e);
            return null;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    protected int converId(String taxonId) throws IdNotValidException {
        try {
            return Integer.parseInt(taxonId);
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)("Invalid id " + taxonId), (Throwable)nfe);
            throw new IdNotValidException();
        }
    }
}

