/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.util;

import java.util.Calendar;
import org.gcube.data.spd.obisplugin.data.Coordinate;
import org.gcube.data.spd.obisplugin.data.SearchFilters;

public class ProductKey {
    public static final String KEY_SEPARATOR = "-";
    protected int taxonId;
    protected int dataSetId;
    protected Coordinate upperBound;
    protected Coordinate lowerBound;
    protected Calendar fromDate;
    protected Calendar toDate;

    public static ProductKey parse(String key) throws Exception {
        String[] tokens = key.split(KEY_SEPARATOR, -1);
        if (tokens.length != 6) {
            throw new Exception("Invalid key " + key + ": expected tokens 6 found " + tokens.length);
        }
        try {
            int taxonId = Integer.parseInt(tokens[0]);
            int dataSetId = Integer.parseInt(tokens[1]);
            Coordinate upperBound = Coordinate.parse(tokens[2]);
            Coordinate lowerBound = Coordinate.parse(tokens[3]);
            Calendar fromDate = ProductKey.parseCalendar(tokens[4]);
            Calendar toDate = ProductKey.parseCalendar(tokens[5]);
            return new ProductKey(taxonId, dataSetId, upperBound, lowerBound, fromDate, toDate);
        }
        catch (Exception e) {
            throw new Exception("An error occurred parsing the key tokens: " + key, e);
        }
    }

    protected static Calendar parseCalendar(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        long time = Long.parseLong(value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar;
    }

    public static String toString(int taxonId, int dataSetId, SearchFilters filters) {
        return ProductKey.toString(taxonId, dataSetId, filters.getUpperBound(), filters.getLowerBound(), filters.getFromDate(), filters.getToDate());
    }

    public static String toString(ProductKey key) {
        return ProductKey.toString(key.getTaxonId(), key.getDataSetId(), key.getUpperBound(), key.getLowerBound(), key.getFromDate(), key.getToDate());
    }

    public static String toString(int taxonId, int dataSetId, Coordinate upperBound, Coordinate lowerBound, Calendar fromDate, Calendar toDate) {
        StringBuilder key = new StringBuilder();
        key.append(taxonId);
        key.append(KEY_SEPARATOR);
        key.append(dataSetId);
        key.append(KEY_SEPARATOR);
        if (upperBound != null) {
            key.append(upperBound.asString());
        }
        key.append(KEY_SEPARATOR);
        if (lowerBound != null) {
            key.append(lowerBound.asString());
        }
        key.append(KEY_SEPARATOR);
        if (fromDate != null) {
            key.append(fromDate.getTimeInMillis());
        }
        key.append(KEY_SEPARATOR);
        if (toDate != null) {
            key.append(toDate.getTimeInMillis());
        }
        return key.toString();
    }

    public ProductKey(int taxonId, int dataSetId, Coordinate upperBound, Coordinate lowerBound, Calendar fromDate, Calendar toDate) {
        this.taxonId = taxonId;
        this.dataSetId = dataSetId;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    public static String getKeySeparator() {
        return KEY_SEPARATOR;
    }

    public int getTaxonId() {
        return this.taxonId;
    }

    public int getDataSetId() {
        return this.dataSetId;
    }

    public Coordinate getUpperBound() {
        return this.upperBound;
    }

    public Coordinate getLowerBound() {
        return this.lowerBound;
    }

    public Calendar getFromDate() {
        return this.fromDate;
    }

    public Calendar getToDate() {
        return this.toDate;
    }

    public SearchFilters getFilter() {
        return new SearchFilters(this.upperBound, this.lowerBound, this.fromDate, this.toDate);
    }
}

