/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ObisNameMapping
implements MappingCapability {
    protected Logger logger = Logger.getLogger(ObisNameMapping.class);
    protected PluginSessionPool sessionPool;

    public ObisNameMapping(PluginSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRelatedScientificNames(final ObjectWriter<String> writer, String commonName) {
        this.logger.debug((Object)("retrieving mapping for " + commonName));
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            ObisClient.getScientificNames(session, commonName, new Writer<String>(){

                @Override
                public boolean write(String item) {
                    writer.write((Object)item);
                    return writer.isAlive();
                }
            });
        }
        catch (SQLException e) {
            this.logger.error((Object)("An error occurred retrieving the mapping for common name " + commonName), (Throwable)e);
            writer.write((StreamException)new StreamBlockingException("OBIS", commonName));
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }
}

