/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ObisClassification
extends ClassificationCapability {
    protected Logger logger = Logger.getLogger(ObisClassification.class);
    protected PluginSessionPool sessionPool;

    public ObisClassification(PluginSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, final ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            ObisClient.getTaxonByScientificNames(session, word, new Writer<TaxonomyItem>(){

                @Override
                public boolean write(TaxonomyItem item) {
                    writer.write((Object)item);
                    return writer.isAlive();
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Object)("Error retrieving taxon with word \"" + word + "\""), (Throwable)e);
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String taxonId) throws IdNotValidException, ExternalRepositoryException {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            int id = this.converId(taxonId);
            List<TaxonomyItem> list = ObisClient.getChildrenTaxon(session, id);
            return list;
        }
        catch (SQLException e) {
            this.logger.error((Object)"Error retrieving TaxonChildsByTaxonId", (Throwable)e);
            throw new ExternalRepositoryException((Throwable)e);
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> reader, ClosableWriter<TaxonomyItem> writer) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            while (reader.hasNext() && writer.isAlive()) {
                try {
                    String taxonId = reader.next();
                    int id = this.converId(taxonId);
                    TaxonomyItem item = ObisClient.getTaxonById(session, id);
                    writer.write((Object)item);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error retrieving TaxonById", (Throwable)e);
                }
            }
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyItem retrieveTaxonById(String taxonId) throws IdNotValidException {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        int id = this.converId(taxonId);
        try {
            TaxonomyItem item;
            TaxonomyItem taxonomyItem = item = ObisClient.getTaxonById(session, id);
            return taxonomyItem;
        }
        catch (IdNotValidException inve) {
            this.logger.error((Object)"Error retrieving TaxonById", (Throwable)inve);
            throw inve;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving TaxonById", (Throwable)e);
            TaxonomyItem taxonomyItem = null;
            return taxonomyItem;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    protected int converId(String taxonId) throws IdNotValidException {
        try {
            return Integer.parseInt(taxonId);
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)("Invalid id " + taxonId), (Throwable)nfe);
            throw new IdNotValidException();
        }
    }
}

