/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.io.File;
import java.net.URI;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.spd.client.ResultGenerator;
import org.gcube.data.spd.client.formats.MapDwCA;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.stubs.ClassificationPortType;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultClassification
implements Classification {
    private final ProxyDelegate<ClassificationPortType> delegate;
    private final ResultGenerator<TaxonomyItem> taxonItemGenerator = new ResultGenerator();

    public DefaultClassification(ProxyDelegate<ClassificationPortType> config) {
        this.delegate = config;
    }

    @Override
    public Stream<TaxonomyItem> getTaxonChildsById(final String id) {
        Call<ClassificationPortType, URI> call = new Call<ClassificationPortType, URI>(){

            public URI call(ClassificationPortType classificationPT) throws Exception {
                return new URI(classificationPT.retrieveTaxonChildsByTaxonId(id));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withDefaults()).through(this.taxonItemGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Stream<TaxonomyItem> getTaxonByIds(Stream<String> ids) {
        final String idsLocator = Streams.publishStringsIn(ids).withDefaults().toString();
        Call<ClassificationPortType, URI> call = new Call<ClassificationPortType, URI>(){

            public URI call(ClassificationPortType classificationPT) throws Exception {
                return new URI(classificationPT.getTaxonByIds(idsLocator));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withDefaults()).through(this.taxonItemGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public File getDarwinCoreArchive(Stream<String> taxonIds) throws Exception {
        return new MapDwCA().createDwCA(taxonIds);
    }

    @Override
    public Stream<TaxonomyItem> getTaxonTreeById(final String id) throws IdNotValidException, Exception {
        Call<ClassificationPortType, URI> call = new Call<ClassificationPortType, URI>(){

            public URI call(ClassificationPortType classificationPT) throws Exception {
                return new URI(classificationPT.retrieveChildrenTreeById(id));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withDefaults()).through(this.taxonItemGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

