/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.core.types.VOID;
import org.gcube.data.spd.client.proxies.Executor;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.stubs.ExecutorPortType;
import org.gcube.data.spd.stubs.JobType;
import org.gcube.data.spd.stubs.StatusResponse;
import org.gcube.data.spd.stubs.SubmitJobRequest;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultExecutor
implements Executor {
    private final ProxyDelegate<ExecutorPortType> delegate;

    public DefaultExecutor(ProxyDelegate<ExecutorPortType> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String createDwCAByChildren(final String taxonKey) throws Exception {
        Call<ExecutorPortType, String> call = new Call<ExecutorPortType, String>(){

            public String call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.submitJob(new SubmitJobRequest(taxonKey, JobType.DWCAByChildren));
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String createDwCAByIds(Stream<String> ids) throws Exception {
        final String idsLocator = Streams.publishStringsIn(ids).withDefaults().toString();
        Call<ExecutorPortType, String> call = new Call<ExecutorPortType, String>(){

            public String call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.submitJob(new SubmitJobRequest(idsLocator, JobType.DWCAById));
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String createCSV(Stream<String> keys) throws Exception {
        final String idsLocator = Streams.publishStringsIn(keys).withDefaults().toString();
        Call<ExecutorPortType, String> call = new Call<ExecutorPortType, String>(){

            public String call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.submitJob(new SubmitJobRequest(idsLocator, JobType.CSV));
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String createCSVforOM(Stream<String> keys) throws Exception {
        final String idsLocator = Streams.publishStringsIn(keys).withDefaults().toString();
        Call<ExecutorPortType, String> call = new Call<ExecutorPortType, String>(){

            public String call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.submitJob(new SubmitJobRequest(idsLocator, JobType.CSVForOM));
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String createDarwincoreFromOccurrenceKeys(Stream<String> keys) throws Exception {
        final String idsLocator = Streams.publishStringsIn(keys).withDefaults().toString();
        Call<ExecutorPortType, String> call = new Call<ExecutorPortType, String>(){

            public String call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.submitJob(new SubmitJobRequest(idsLocator, JobType.DarwinCore));
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String getResultLink(final String jobId) throws IdNotValidException {
        Call<ExecutorPortType, String> call = new Call<ExecutorPortType, String>(){

            public String call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.getResultLink(jobId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(IdNotValidException.class);
        }
    }

    @Override
    public StatusResponse getStatus(final String jobId) throws IdNotValidException {
        Call<ExecutorPortType, StatusResponse> call = new Call<ExecutorPortType, StatusResponse>(){

            public StatusResponse call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.getStatus(jobId);
            }
        };
        try {
            return (StatusResponse)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(IdNotValidException.class);
        }
    }

    @Override
    public void removeJob(final String jobId) throws IdNotValidException {
        Call<ExecutorPortType, VOID> call = new Call<ExecutorPortType, VOID>(){

            public VOID call(ExecutorPortType dwcaPT) throws Exception {
                return dwcaPT.removeJob(jobId);
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(IdNotValidException.class);
        }
    }
}

