/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.data.spd.client.ResultGenerator;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.ResultElement;
import org.gcube.data.spd.model.exceptions.InvalidQueryException;
import org.gcube.data.spd.stubs.ManagerStub;
import org.gcube.data.spd.stubs.exceptions.UnsupportedPluginException;
import org.gcube.data.spd.stubs.types.PluginDescription;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultManager
implements Manager {
    private final ProxyDelegate<ManagerStub> delegate;
    private final ResultGenerator<ResultElement> resultElementGenerator = new ResultGenerator();

    public DefaultManager(ProxyDelegate<ManagerStub> config) {
        this.delegate = config;
    }

    @Override
    public Stream<ResultElement> search(final String query) throws InvalidQueryException, UnsupportedPluginException {
        Call<ManagerStub, URI> call = new Call<ManagerStub, URI>(){

            public URI call(ManagerStub manager) throws Exception {
                return new URI(manager.search(query));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withTimeout(((Integer)this.delegate.config().property("streamTimeoutInMinutes", Integer.class)).intValue(), TimeUnit.MINUTES)).through(this.resultElementGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<PluginDescription> getPluginsDescription() {
        Call<ManagerStub, List<PluginDescription>> call = new Call<ManagerStub, List<PluginDescription>>(){

            public List<PluginDescription> call(ManagerStub manager) throws Exception {
                ArrayList descriptions = manager.getSupportedPlugins(JAXWSUtils.empty).getDescriptions();
                return descriptions == null ? new ArrayList(0) : descriptions;
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

