/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.spd.client.ResultElementRecordIterator;
import org.gcube.data.spd.client.ResultLocator;
import org.gcube.data.spd.client.Utils;
import org.gcube.data.spd.client.proxies.ClassificationClient;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.service.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedCapabilityException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedPluginException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultClassification
implements ClassificationClient {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultClassification(ProxyDelegate<WebTarget> config) {
        this.delegate = config;
    }

    @Override
    public Stream<TaxonomyItem> getTaxonChildrenById(final String id) throws UnsupportedPluginException, UnsupportedCapabilityException, InvalidIdentifierException {
        Call<WebTarget, ResultLocator> call = new Call<WebTarget, ResultLocator>(){

            public ResultLocator call(WebTarget manager) throws Exception {
                Response response = (Response)manager.path("children").path(id).request().get(Response.class);
                String host = manager.getUri().getHost();
                int port = manager.getUri().getPort();
                return new ResultLocator(host, port, Utils.getLocatorFromResponse(response));
            }
        };
        try {
            ResultLocator result = (ResultLocator)this.delegate.make((Call)call);
            ResultElementRecordIterator ri = new ResultElementRecordIterator(result, 2L, TimeUnit.MINUTES);
            return Streams.convert(ri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<TaxonomyItem> getTaxaByIds(List<String> ids) {
        return null;
    }

    @Override
    public Stream<TaxonomyItem> getTaxonTreeById(final String id) throws UnsupportedPluginException, UnsupportedCapabilityException, InvalidIdentifierException {
        Call<WebTarget, ResultLocator> call = new Call<WebTarget, ResultLocator>(){

            public ResultLocator call(WebTarget manager) throws Exception {
                Response response = (Response)manager.path("tree").path(id).request().get(Response.class);
                String host = manager.getUri().getHost();
                int port = manager.getUri().getPort();
                return new ResultLocator(host, port, Utils.getLocatorFromResponse(response));
            }
        };
        try {
            ResultLocator result = (ResultLocator)this.delegate.make((Call)call);
            ResultElementRecordIterator ri = new ResultElementRecordIterator(result, 2L, TimeUnit.MINUTES);
            return Streams.convert(ri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<TaxonomyItem> getSynonymsById(final String id) throws UnsupportedPluginException, UnsupportedCapabilityException, InvalidIdentifierException {
        Call<WebTarget, ResultLocator> call = new Call<WebTarget, ResultLocator>(){

            public ResultLocator call(WebTarget manager) throws Exception {
                Response response = (Response)manager.path("synonyms").path(id).request().get(Response.class);
                String host = manager.getUri().getHost();
                int port = manager.getUri().getPort();
                return new ResultLocator(host, port, Utils.getLocatorFromResponse(response));
            }
        };
        try {
            ResultLocator result = (ResultLocator)this.delegate.make((Call)call);
            ResultElementRecordIterator ri = new ResultElementRecordIterator(result, 2L, TimeUnit.MINUTES);
            return Streams.convert(ri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

