/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.spd.client.ResultElementRecordIterator;
import org.gcube.data.spd.client.ResultLocator;
import org.gcube.data.spd.client.Utils;
import org.gcube.data.spd.client.proxies.ManagerClient;
import org.gcube.data.spd.model.PluginDescription;
import org.gcube.data.spd.model.exceptions.InvalidQueryException;
import org.gcube.data.spd.model.products.ResultElement;
import org.gcube.data.spd.model.service.exceptions.UnsupportedCapabilityException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedPluginException;
import org.gcube.data.spd.model.service.types.PluginDescriptions;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultManager
implements ManagerClient {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultManager(ProxyDelegate<WebTarget> config) {
        this.delegate = config;
    }

    @Override
    public <T extends ResultElement> Stream<T> search(final String query) throws InvalidQueryException, UnsupportedPluginException, UnsupportedCapabilityException {
        Call<WebTarget, ResultLocator> call = new Call<WebTarget, ResultLocator>(){

            public ResultLocator call(WebTarget manager) throws Exception {
                Response response = (Response)manager.path("search").queryParam("query", new Object[]{query}).request().get(Response.class);
                String host = manager.getUri().getHost();
                int port = manager.getUri().getPort();
                return new ResultLocator(host, port, Utils.getLocatorFromResponse(response));
            }
        };
        try {
            ResultLocator result = (ResultLocator)this.delegate.make((Call)call);
            ResultElementRecordIterator ri = new ResultElementRecordIterator(result, 2L, TimeUnit.MINUTES);
            return Streams.convert(ri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<PluginDescription> getPluginsDescription() {
        Call<WebTarget, List<PluginDescription>> call = new Call<WebTarget, List<PluginDescription>>(){

            public List<PluginDescription> call(WebTarget manager) throws Exception {
                return ((PluginDescriptions)manager.path("providers").request().get(PluginDescriptions.class)).getDescriptions();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

