/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.plugins;

import org.gcube.common.clients.LegacyQuery;
import org.gcube.common.clients.Plugin;
import org.gcube.common.clients.ProxyBuilder;
import org.gcube.common.clients.ProxyBuilderImpl;
import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.queries.Query;
import org.gcube.data.spd.client.plugins.ClassificationPlugin;
import org.gcube.data.spd.client.plugins.ExecutorPlugin;
import org.gcube.data.spd.client.plugins.ManagerPlugin;
import org.gcube.data.spd.client.plugins.OccurrencePlugin;
import org.gcube.data.spd.client.plugins.ResultSetPlugin;
import org.gcube.data.spd.client.proxies.ClassificationClient;
import org.gcube.data.spd.client.proxies.ExecutorClient;
import org.gcube.data.spd.client.proxies.ManagerClient;
import org.gcube.data.spd.client.proxies.OccurrenceClient;
import org.gcube.data.spd.client.proxies.ResultSetClient;

public abstract class AbstractPlugin<S, P>
implements Plugin<S, P> {
    private static final ManagerPlugin manager_plugin = new ManagerPlugin();
    private static final OccurrencePlugin occurrence_plugin = new OccurrencePlugin();
    private static final ClassificationPlugin classification_plugin = new ClassificationPlugin();
    private static final ExecutorPlugin executor_plugin = new ExecutorPlugin();
    private static final ResultSetPlugin resultset_plugin = new ResultSetPlugin();
    public final String name;

    public static ProxyBuilder<ManagerClient> manager() {
        return new ProxyBuilderImpl((Plugin)manager_plugin, new Property[0]);
    }

    public static ProxyBuilder<ClassificationClient> classification() {
        return new ProxyBuilderImpl((Plugin)classification_plugin, new Property[0]);
    }

    public static ProxyBuilder<OccurrenceClient> occurrences() {
        return new ProxyBuilderImpl((Plugin)occurrence_plugin, new Property[0]);
    }

    public static ProxyBuilder<ExecutorClient> executor() {
        return new ProxyBuilderImpl((Plugin)executor_plugin, new Property[0]);
    }

    public static ProxyBuilder<ResultSetClient> resultset(String endpointId) {
        LegacyQuery query = new LegacyQuery((Plugin)resultset_plugin);
        query.addCondition("$Resource/ID/string() eq '" + endpointId + "'");
        return new ProxyBuilderImpl((Plugin)resultset_plugin, (Query)query, new Property[0]);
    }

    public AbstractPlugin(String name) {
        this.name = name;
    }

    public String serviceClass() {
        return "DataAccess";
    }

    public String serviceName() {
        return "SpeciesProductsDiscovery";
    }

    public String namespace() {
        return "http://gcube-system.org/namespaces/data/speciesproductsdiscovery";
    }

    public String name() {
        return this.name;
    }
}

