/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.ResultSetClient;
import org.glassfish.jersey.client.ChunkParser;
import org.glassfish.jersey.client.ChunkedInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JerseyRecordIterator<T>
implements Iterator<T>,
Closeable {
    private Logger logger = LoggerFactory.getLogger(JerseyRecordIterator.class);
    private ChunkedInput<String> chunkedInput;
    private LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();
    private long INTERNAL_TIMEOUT_IN_MILLIS = 1000L;
    private long timeoutInMillis;
    private ResultSetClient resultSetClient;
    private String locator;
    private ChunkedInputReader chunkedInputReader;
    String currentElement;

    public JerseyRecordIterator(String endpointId, String locator, long timeout, TimeUnit timeoutUnit) {
        this.resultSetClient = (ResultSetClient)AbstractPlugin.resultset(endpointId).build();
        this.locator = locator;
        this.timeoutInMillis = timeoutUnit.toMillis(timeout);
    }

    @Override
    public boolean hasNext() {
        if (this.chunkedInput == null) {
            this.initializeChunckedInput();
        }
        if (this.chunkedInput.isClosed() && this.queue.isEmpty()) {
            return false;
        }
        try {
            long startTime = System.currentTimeMillis();
            String retrievedElement = null;
            while (!(retrievedElement != null || System.currentTimeMillis() - startTime > this.timeoutInMillis || this.chunkedInput.isClosed() && this.queue.isEmpty())) {
                retrievedElement = this.queue.poll(this.INTERNAL_TIMEOUT_IN_MILLIS, TimeUnit.MILLISECONDS);
            }
            this.currentElement = retrievedElement;
            return this.currentElement != null;
        }
        catch (InterruptedException e) {
            this.logger.warn("timeout expired", (Throwable)e);
            return false;
        }
    }

    private void initializeChunckedInput() {
        this.chunkedInput = this.resultSetClient.getResultSet(this.locator);
        this.chunkedInput.setParser((ChunkParser)new RecordChunkParser());
        this.chunkedInputReader = new ChunkedInputReader();
        this.chunkedInputReader.start();
    }

    @Override
    public T next() {
        try {
            return this.convertFromString(this.currentElement);
        }
        catch (Exception e) {
            this.logger.warn("error deserializing element", (Throwable)e);
            return null;
        }
    }

    public abstract T convertFromString(String var1);

    @Override
    public void remove() {
        this.chunkedInput.close();
        this.chunkedInputReader.interrupt();
        this.resultSetClient.closeResultSet(this.locator);
        this.queue = null;
    }

    @Override
    public void close() throws IOException {
        this.logger.debug("closing iterator");
        this.remove();
    }

    class ChunkedInputReader
    extends Thread {
        ChunkedInputReader() {
        }

        @Override
        public void run() {
            while (!JerseyRecordIterator.this.chunkedInput.isClosed() && JerseyRecordIterator.this.chunkedInput.read() != null) {
            }
        }
    }

    class RecordChunkParser
    implements ChunkParser {
        RecordChunkParser() {
        }

        public byte[] readChunk(InputStream responseStream) throws IOException {
            XMLEventReader xmlr = null;
            XMLOutputFactory of = null;
            XMLEventWriter xmlSW = null;
            try {
                XMLInputFactory xmlif = XMLInputFactory.newInstance();
                xmlr = xmlif.createXMLEventReader(responseStream);
                of = XMLOutputFactory.newInstance();
                xmlSW = null;
                StringWriter sw = new StringWriter();
                while (xmlr.hasNext() && JerseyRecordIterator.this.queue != null) {
                    XMLEvent e = xmlr.nextEvent();
                    int eventType = e.getEventType();
                    if (eventType == 1 && ((StartElement)e).getName().getLocalPart().equals("Result")) {
                        xmlSW = of.createXMLEventWriter(sw);
                        continue;
                    }
                    if (eventType == 2 && ((EndElement)e).getName().getLocalPart().equals("Result")) {
                        JerseyRecordIterator.this.queue.add(sw.toString());
                        sw = new StringWriter();
                        xmlSW.close();
                        xmlSW = null;
                        continue;
                    }
                    if (eventType == 2 && ((EndElement)e).getName().getLocalPart().equals("Results")) {
                        break;
                    }
                    if (xmlSW == null) continue;
                    xmlSW.add(e);
                }
            }
            catch (Exception e) {
                JerseyRecordIterator.this.logger.error("error parsing the input", (Throwable)e);
                throw new IOException(e);
            }
            finally {
                try {
                    if (xmlr != null) {
                        xmlr.close();
                    }
                }
                catch (XMLStreamException e) {
                    JerseyRecordIterator.this.logger.warn("error closing the event reader", (Throwable)e);
                }
                try {
                    if (xmlSW != null) {
                        xmlSW.close();
                    }
                }
                catch (XMLStreamException e) {
                    JerseyRecordIterator.this.logger.warn("error closing the event writer", (Throwable)e);
                }
            }
            return null;
        }
    }
}

