/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.specieslink;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Coordinate;

public class Utils {
    public static String credits;

    static String elaborateProps(Condition[] properties) throws Exception {
        StringBuilder props = new StringBuilder();
        block4: for (Condition prop : properties) {
            String operator = Utils.getOperator(prop.getOp());
            switch (prop.getType()) {
                case COORDINATE: {
                    Coordinate coord = (Coordinate)prop.getValue();
                    double latitude = coord.getLatitude();
                    double longitude = coord.getLongitude();
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLatitude%20");
                    props.append(operator);
                    props.append("%20%22");
                    props.append(latitude);
                    props.append("%22");
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLongitude%20");
                    props.append(operator);
                    props.append("%20%22");
                    props.append(longitude);
                    props.append("%22");
                    continue block4;
                }
                case DATE: {
                    Calendar calendarDate = (Calendar)prop.getValue();
                    SimpleDateFormat dfFrom = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                    props.append("%20and%20http://rs.tdwg.org/dwc/terms/eventTime%20");
                    props.append(operator);
                    props.append("%20%22");
                    props.append(dfFrom.format(calendarDate.getTime()));
                    props.append("%22");
                    continue block4;
                }
            }
        }
        return props.toString();
    }

    private static String getOperator(Condition.Operator op) {
        if (op.equals((Object)Condition.Operator.EQ)) {
            return "equals";
        }
        if (op.equals((Object)Condition.Operator.GE)) {
            return "greaterThanOrEquals";
        }
        if (op.equals((Object)Condition.Operator.GT)) {
            return "greaterThan";
        }
        if (op.equals((Object)Condition.Operator.LE)) {
            return "lessThanOrEquals";
        }
        if (op.equals((Object)Condition.Operator.LT)) {
            return "lessThan";
        }
        return null;
    }

    public static String credits() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with speciesLink (http://splink.cria.org.br/)".replace("XDATEX", format.format(now.getTime()));
        return credits;
    }

    public static String citation() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String citation = "Accessed through: speciesLink at http://splink.cria.org.br/ on XDATEX".replace("XDATEX", format.format(now.getTime()));
        return citation;
    }
}

