/**
 * 
 */
package org.gcube.dataaccess.spql.model;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class ParserCoordinate {
	
	protected double latitude;
	protected double longitude;
	
	public ParserCoordinate(String latitude, String longitude) {
		this(Double.parseDouble(latitude), Double.parseDouble(longitude));
	}
	
	/**
	 * @param latitude
	 * @param longitude
	 */
	public ParserCoordinate(double latitude, double longitude) {
		this.latitude = latitude;
		this.longitude = longitude;
	}

	/**
	 * @return the latitude
	 */
	public double getLatitude() {
		return latitude;
	}

	/**
	 * @return the longitude
	 */
	public double getLongitude() {
		return longitude;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ParserCoordinate [latitude=");
		builder.append(latitude);
		builder.append(", longitude=");
		builder.append(longitude);
		builder.append("]");
		return builder.toString();
	}

}
