/**
 * 
 */
package org.gcube.dataaccess.spql.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class ParsingResult {
	
	protected Map<TermType, List<String>> terms;
	protected List<String> plugins;
	protected ReturnExpression returnExpression;
	protected List<Condition> conditions;
	
	public ParsingResult()
	{
		terms = new HashMap<TermType, List<String>>();
		plugins = new ArrayList<String>();
		conditions = new ArrayList<Condition>();
	}
	
	/**
	 * @return the terms
	 */
	public Map<TermType, List<String>> getTerms() {
		return terms;
	}
	
	/**
	 * @param terms the terms to set
	 */
	public void setTerms(List<TermWords> tws) {
		for (TermWords tw:tws) {
			List<String> words = terms.get(tw.getType());
			if (words == null) words = tw.getWords();
			else words.addAll(tw.getWords());
			terms.put(tw.getType(), words);
		}
	}
	
	/**
	 * @return the plugins
	 */
	public List<String> getPlugins() {
		return plugins;
	}
	
	/**
	 * @param plugins the plugins to set
	 */
	public void setPlugins(List<String> plugins) {
		this.plugins = plugins;
	}
	
	/**
	 * @return the returnExpression
	 */
	public ReturnExpression getReturnExpression() {
		return returnExpression;
	}

	/**
	 * @param returnExpression the returnExpression to set
	 */
	public void setReturnExpression(ReturnExpression returnExpression) {
		this.returnExpression = returnExpression;
	}

	/**
	 * @return the conditions
	 */
	public List<Condition> getConditions() {
		return conditions;
	}
	
	/**
	 * @param conditions the conditions to set
	 */
	public void setConditions(List<Condition> conditions) {
		this.conditions = conditions;
	}
}
