/**
 * 
 */
package org.gcube.dataaccess.spql.stmt;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class InStatement extends AbstractStatement {

	protected boolean firstDatasource;
	
	protected InStatement(StringBuilder query, String ... datasources) {
		super(query);
		firstDatasource = true;
		in(datasources);
	}
	

	protected void checkFirst()
	{
		if (firstDatasource) query.append(" in ");
		else query.append(", ");
		firstDatasource = false;
	}

	public InStatement in(String ... datasources)
	{
		checkFirst();
		if (datasources!=null && datasources.length!=0) appendNames(datasources);
		return this;
	}
	
	public WhereStatement where()
	{
		return new WhereStatement(query);
	}
}
