/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DarwinRecord {
    public int globalUniqueIdentifier;
    public Calendar dateLastModified;
    public String basisOfRecord;
    public String institutionCode;
    public String collectionCode;
    public String catalogNumber;
    public String remarks;
    public String scientificName;
    public String kingdom;
    public String phylum;
    public String clazz;
    public String order;
    public String family;
    public String genus;
    public String specificEpithet;
    public String infraspecificEpithet;
    public String authorYearOfScientificName;
    public String continent;
    public String country;
    public String locality;
    public String stateProvince;
    public int minimumElevationInMeters;
    public int maximumElevationInMeters;
    public int minimumDepthInMeters;
    public int maximumDepthInMeters;
    public String dayOfYear;
    public String collector;
    public String sex;
    public double decimalLatitude;
    public double decimalLongitude;
    public double verbatimLatitude;
    public double verbatimLongitude;
    public String identifiedBy;
    public String collectorNumber;
    public String fieldNumber;
    public String typeStatus;
    public String individualCount;
    public static SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");

    public DarwinRecord(Element eElement) {
        this.globalUniqueIdentifier = Integer.parseInt(this.getTagValue("dwcore:GlobalUniqueIdentifier", eElement));
        this.scientificName = this.getTagValue("dwcore:ScientificName", eElement);
        this.authorYearOfScientificName = this.getTagValue("dwcore:AuthorYearOfScientificName", eElement);
        this.basisOfRecord = this.getTagValue("dwcore:BasisOfRecord", eElement);
        this.catalogNumber = this.getTagValue("dwcore:CatalogNumber", eElement);
        this.clazz = this.getTagValue("dwcore:Class", eElement);
        this.collectionCode = this.getTagValue("dwcore:CollectionCode", eElement);
        this.collector = this.getTagValue("dwcore:Collector", eElement);
        this.collectorNumber = this.getTagValue("dwcur:CollectorNumber", eElement);
        this.continent = this.getTagValue("dwcore:Continent", eElement);
        this.country = this.getTagValue("dwcore:Country", eElement);
        String dateL = this.getTagValue("dwcore:DateLastModified", eElement).replace("T", " ");
        try {
            Calendar dateC;
            this.dateLastModified = dateC = this.dateString2Calendar(dateL);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.dayOfYear = this.getTagValue("dwcore:DayOfYear", eElement);
        this.family = this.getTagValue("dwcore:Family", eElement);
        this.fieldNumber = this.getTagValue("dwcur:FieldNumber", eElement);
        this.genus = this.getTagValue("dwcore:Genus", eElement);
        this.identifiedBy = this.getTagValue("dwcur:IdentifiedBy", eElement);
        this.individualCount = this.getTagValue("dwcur:IndividualCount", eElement);
        this.infraspecificEpithet = this.getTagValue("dwcore:InfraspecificEpithet", eElement);
        this.institutionCode = this.getTagValue("dwcore:InstitutionCode", eElement);
        this.kingdom = this.getTagValue("dwcore:Kingdom", eElement);
        this.locality = this.getTagValue("dwcore:Locality", eElement);
        this.order = this.getTagValue("dwcore:Order", eElement);
        this.phylum = this.getTagValue("dwcore:Phylum", eElement);
        this.remarks = this.getTagValue("dwcore:Remarks", eElement);
        this.sex = this.getTagValue("dwcore:Sex", eElement);
        this.specificEpithet = this.getTagValue("dwcore:SpecificEpithet", eElement);
        this.stateProvince = this.getTagValue("dwcore:StateProvince", eElement);
        this.typeStatus = this.getTagValue("dwcore:TypeStatus", eElement);
        try {
            this.decimalLatitude = Double.parseDouble(this.getTagValue("dwgeo:DecimalLatitude", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.decimalLongitude = Double.parseDouble(this.getTagValue("dwgeo:DecimalLongitude", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.maximumDepthInMeters = Integer.parseInt(this.getTagValue("dwcore:MaximumDepthInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.maximumElevationInMeters = Integer.parseInt(this.getTagValue("dwcore:MaximumElevationInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.minimumDepthInMeters = Integer.parseInt(this.getTagValue("dwcore:MinimumDepthInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.minimumElevationInMeters = Integer.parseInt(this.getTagValue("dwcore:MinimumElevationInMeters", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.verbatimLatitude = Double.parseDouble(this.getTagValue("dwgeo:VerbatimLatitude", eElement));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.verbatimLongitude = Double.parseDouble(this.getTagValue("dwgeo:VerbatimLongitude", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private String getTagValue(String sTag, Element eElement) {
        Node nValue;
        NodeList textFNList;
        Element xmlNode;
        String a = "";
        NodeList nlList = eElement.getElementsByTagName(sTag);
        if (nlList != null && (xmlNode = (Element)nlList.item(0)) != null && (textFNList = xmlNode.getChildNodes()) != null && (nValue = textFNList.item(0)) != null) {
            a = nValue.getNodeValue();
        }
        return a;
    }

    private Calendar dateString2Calendar(String s) throws ParseException {
        Calendar cal = Calendar.getInstance();
        Date d1 = df.parse(s);
        cal.setTime(d1);
        return cal;
    }
}

