/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.parser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.parser.DarwinRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RecordsIterator
implements Iterator<DarwinRecord> {
    GCUBELog logger = new GCUBELog(RecordsIterator.class);
    public final int limit = 10;
    public NodeList sum = null;
    public int start = 0;
    public int count = 0;
    public String pathUrl = null;
    public int i = -1;
    public NodeList nList = null;
    public String filter;
    public String baseurl;
    public String model;
    public DocumentBuilderFactory dbFactory;
    public DocumentBuilder dBuilder;
    public Document doc;

    public RecordsIterator(String baseurl, String filter, String model) {
        this.baseurl = baseurl;
        this.filter = filter;
        this.model = model;
        this.pathUrl = baseurl + "?op=search&start=" + this.start + "&limit=" + 10 + "&filter=" + filter + "&model=" + model;
    }

    @Override
    public DarwinRecord next() {
        Node nNode;
        DarwinRecord dr = null;
        Element eElement = null;
        if (this.i < this.nList.getLength() && this.nList.getLength() > 0 && (nNode = this.nList.item(this.i)).getNodeType() == 1) {
            eElement = (Element)nNode;
            dr = new DarwinRecord(eElement);
        }
        return dr;
    }

    @Override
    public boolean hasNext() {
        ++this.i;
        if (this.nList != null) {
            if (this.nList.getLength() == 0) {
                return false;
            }
            if (this.i < this.nList.getLength()) {
                return true;
            }
            try {
                Element el;
                Node nNode;
                this.pathUrl = "";
                this.sum = this.doc.getElementsByTagName("summary");
                if (this.sum.getLength() > 0 && (nNode = this.sum.item(0)).getNodeType() == 1 && (el = (Element)nNode).getAttribute("next") != "") {
                    ++this.count;
                    this.pathUrl = this.baseurl + "?op=search&start=" + 10 * this.count + "&limit=" + 10 + "&filter=" + this.filter + "&model=" + this.model;
                    this.doc = this.dBuilder.parse(new URL(this.pathUrl).openStream());
                    this.doc.getDocumentElement().normalize();
                    this.nList = this.getDoc(this.doc);
                    this.i = -1;
                    return this.hasNext();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Error opening stream", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public RecordsIterator iterator() {
        try {
            this.dbFactory = DocumentBuilderFactory.newInstance();
            this.dBuilder = this.dbFactory.newDocumentBuilder();
            this.doc = this.dBuilder.parse(new URL(this.pathUrl).openStream());
            this.doc.getDocumentElement().normalize();
            this.nList = this.getDoc(this.doc);
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)"Error MalformedURL", (Throwable)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)"Error elaborating XML", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Error opening stream", (Throwable)e);
        }
        return this;
    }

    public NodeList getDoc(Document doc) {
        try {
            this.nList = doc.getElementsByTagName("dwrec:DarwinRecord");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.nList;
    }
}

