/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.parser.DarwinSimpleRecord;
import org.gcube.data.spd.parser.Utils;
import org.w3c.dom.NodeList;

public class RecordsIterator
implements Iterator<DarwinSimpleRecord> {
    GCUBELog logger = new GCUBELog(RecordsIterator.class);
    public NodeList sum = null;
    public int start = 0;
    public int count = 0;
    public String pathUrl;
    public String filter;
    public String baseurl;
    public String model;
    public int limit;
    public XMLEventReader eventReader = null;
    public XMLInputFactory ifactory = null;
    public InputStream inputStream = null;

    public RecordsIterator(String baseurl, String filter, String model, int limit) {
        this.baseurl = baseurl;
        this.filter = filter;
        this.model = model;
        this.limit = limit;
        this.pathUrl = String.valueOf(baseurl) + "?op=search&start=" + this.start + "&limit=" + limit + "&filter=" + filter + "&model=" + model;
    }

    @Override
    public DarwinSimpleRecord next() {
        DarwinSimpleRecord record = null;
        try {
            record = new DarwinSimpleRecord(this.eventReader);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error creating DarwinCore Record from: " + this.pathUrl), (Throwable)e);
        }
        return record;
    }

    @Override
    public boolean hasNext() {
        block4: {
            if (!this.getRecord()) break block4;
            return true;
        }
        try {
            if (this.checkSummary()) {
                ++this.count;
                this.pathUrl = String.valueOf(this.baseurl) + "?op=search&start=" + this.limit * this.count + "&limit=" + this.limit + "&filter=" + this.filter + "&model=" + this.model;
                this.iterator();
                return this.hasNext();
            }
        }
        catch (XMLStreamException e) {
            this.logger.error((Object)("Error getting more records from: " + this.pathUrl), (Throwable)e);
        }
        return false;
    }

    private boolean checkSummary() throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!Utils.checkStartElement(event, "summary")) continue;
            StartElement element = (StartElement)event;
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                int next;
                Attribute attribute = iterator.next();
                QName att = attribute.getName();
                if (!att.toString().equals("next") || (next = Integer.parseInt(attribute.getValue())) <= 0) continue;
                return true;
            }
            break block0;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public RecordsIterator iterator() {
        try {
            this.inputStream = URI.create(this.pathUrl).toURL().openStream();
            this.ifactory = XMLInputFactory.newInstance();
            this.eventReader = this.ifactory.createXMLEventReader(this.inputStream);
        }
        catch (XMLStreamException e) {
            this.logger.error((Object)("XMLStreamException in " + this.pathUrl), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)("FileNotFoundException: " + this.pathUrl), (Throwable)e);
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)("MalformedURLException: " + this.pathUrl), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)("IOException, url: " + this.pathUrl), (Throwable)e);
        }
        return this;
    }

    public boolean getRecord() throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (Utils.checkStartElement(event, "DarwinRecord")) break;
            if (Utils.checkEndElement(event, "DarwinRecordSet")) {
                return false;
            }
            if (!Utils.checkEndElement(event, "response")) continue;
            this.logger.info((Object)("No results at url: " + this.pathUrl));
            return false;
        }
        return true;
    }
}

