package org.gcube.datatransfer.agent.library.proxies;

import org.gcube.common.clients.gcore.builders.StatelessBuilder;
import org.gcube.common.clients.gcore.builders.StatelessBuilderImpl;
import org.gcube.common.clients.gcore.queries.StatelessQuery;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.Constants;
import org.gcube.datatransfer.agent.library.plugins.AgentServicePlugin;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DataTransferAgentPortType;

public class Proxies {
	
	private static final AgentServicePlugin plugin = new AgentServicePlugin();
	 
	public static StatelessBuilder<AgentLibrary> transferAgent() {
	    return new StatelessBuilderImpl<DataTransferAgentPortType,AgentLibrary>(plugin);
	}

	
	public static StatelessQuery instance() {
		StatelessQuery query = new StatelessQuery(plugin);
	    query.addCondition("//ServiceName",Constants.SERVICE_NAME);
	    query.addCondition("//ServiceClass",Constants.SERVICE_CLASS);
	    return query;
	  }
}
