/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.library.grs;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.grs.FileRecord;

public class GRSFileWriter
extends Thread {
    private RecordWriter<GenericRecord> writer = null;
    private ArrayList<File> files = null;
    private GCUBELog logger = new GCUBELog(this.getClass());

    public GRSFileWriter(IWriterProxy proxy, ArrayList<File> inputFiles) throws GRS2WriterException {
        this.files = inputFiles;
        this.writer = new RecordWriter(proxy, FileRecord.fileRecordDef, inputFiles.size(), 2, 0.5f);
    }

    public URI getLocator() throws GRS2WriterException {
        return this.writer.getLocator();
    }

    @Override
    public void run() {
        for (File file : this.files) {
            if (file.isDirectory()) {
                this.logger.debug((Object)("File " + file + " is a directory and cannot be transferred"));
                continue;
            }
            try {
                if (this.writer.getStatus() != IBuffer.Status.Open) {
                    return;
                }
                GenericRecord rec = new GenericRecord();
                rec.setFields(new Field[]{new FileField(file), new StringField(file.getName())});
                if (!this.writer.put((Record)rec, 60L, TimeUnit.SECONDS)) {
                    return;
                }
                this.logger.debug((Object)"Succesfully written outcome");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.logger.debug((Object)"All Outcomes Succesfully written");
        if (this.writer.getStatus() != IBuffer.Status.Dispose) {
            try {
                this.writer.close();
                this.logger.debug((Object)"Writer closed");
            }
            catch (GRS2WriterException e) {
                e.printStackTrace();
            }
        }
    }

    public RecordWriter<GenericRecord> getWriter() {
        return this.writer;
    }

    public void setWriter(RecordWriter<GenericRecord> writer) {
        this.writer = writer;
    }
}

