/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.porttype;

import java.util.concurrent.FutureTask;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.AgentContext;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.state.AgentResource;
import org.gcube.datatransfer.agent.impl.worker.AgentTransferWorker;
import org.gcube.datatransfer.agent.impl.worker.TreeManagerWorker;
import org.gcube.datatransfer.agent.library.utils.Utils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StartTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

public class DataTransferAgent
extends GCUBEPortType {
    protected final GCUBELog logger = new GCUBELog(DataTransferAgent.class);
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();

    private AgentResource getResource() throws Exception {
        return AgentContext.getContext().getAgent();
    }

    public String startTransfer(StartTransferMessage message) throws TransferFault {
        this.logger.info((Object)("Start Transfer invoked in scope " + message.getSource().getScope()));
        String id = uuidgen.nextUUID();
        try {
            if (message.getSource().getType().getValue().compareTo(TransferType.TreeBasedTransfer.getValue()) != 0) {
                this.logger.debug((Object)("Local transfer from  URI :" + message.getSource().getInputURIs()[0]));
                AgentTransferWorker worker = new AgentTransferWorker(id, message.getSource(), message.getDest());
                return (String)worker.call();
            }
            this.logger.debug((Object)("SOURCE ID :" + message.getSource().getInputSource().getSourceId()));
            TreeManagerWorker worker = new TreeManagerWorker(id, message.getSource(), message.getDest());
            FutureTask task = new FutureTask(worker);
            worker.setTask(task);
            Thread t = new Thread(task);
            t.start();
            this.getResource().getWorkerMap().put(id, task);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to perform the transfer", (Throwable)e);
            throw (TransferFault)Utils.newFault((GCUBEFault)new TransferFault(), (Throwable)e);
        }
        return id;
    }

    public String cancelTransfer(CancelTransferMessage message) throws CancelTransferFault {
        String handlerID = message.getTransferID();
        FutureTask handler = null;
        try {
            try {
                handler = this.getResource().getWorkerMap().get(handlerID);
                if (handler != null) {
                    handler.cancel(message.isForceStop());
                } else {
                    this.logger.debug((Object)"null handler");
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to cancel the transfer", (Throwable)e);
                throw (CancelTransferFault)Utils.newFault((GCUBEFault)new CancelTransferFault(), (Throwable)e);
            }
        }
        finally {
            try {
                this.getResource().getWorkerMap().remove(handlerID);
            }
            catch (Exception e) {
                throw (CancelTransferFault)Utils.newFault((GCUBEFault)new CancelTransferFault(), (Throwable)e);
            }
        }
        return handlerID;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

