/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.sync;

import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import java.io.File;
import java.net.URI;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.grs.GRSFileReader;
import org.gcube.datatransfer.agent.impl.streams.StreamCopyListener;
import org.gcube.datatransfer.agent.impl.worker.SyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

public class LocalTransferSyncWorker
extends SyncWorker {
    private static final long serialVersionUID = 1L;
    StreamCopyListener listener = null;
    GRSFileReader t = null;

    public LocalTransferSyncWorker(String tranferID, SourceData source, DestData dest) throws GRS2WriterException {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
        this.listener = new StreamCopyListener(tranferID, source, dest);
    }

    public Object call() throws Exception {
        String uri = this.sourceParameters.getInputURIs()[0];
        String outFolder = this.destParameters.getOutUri().getOutUris()[0];
        boolean overwrite = this.destParameters.getOutUri().isOverwrite();
        File out = new File(String.valueOf(ServiceContext.getContext().getVfsRoot()) + File.separator + outFolder);
        this.t = new GRSFileReader(new URI(uri), out, overwrite);
        this.t.run();
        return this.t.getOutcomeLocator();
    }

    @Override
    public String getOutcomeLocator() throws GRS2WriterException {
        return this.t.getOutcomeLocator();
    }
}

