/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.context;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.datatransfer.agent.impl.db.DataTransferDBManager;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.event.TransferEventConsumer;
import org.gcube.datatransfer.agent.impl.utils.Constants;
import org.gcube.datatransfer.agent.impl.vfs.VFileSystemManager;

public class ServiceContext
extends GCUBEServiceContext {
    public static final String JNDI_NAME = "gcube/datatransfer/agent";
    public static final int FILESXTHREAD = 100;
    protected static final ServiceContext cache = new ServiceContext();
    private boolean useMessaging = false;
    private String dbConfigurationFileName;
    private String vfsRoot;
    private String awsKeyID;
    private String awsKey;
    private int connectionTimeout;
    private int transferTimeout;
    private int retryLimit;
    private VFileSystemManager localFSManager;
    private DataTransferDBManager dbManager = null;
    public static GCUBEProducer<Events.TransferTopics, Object> transferEventproducer = new GCUBEProducer();

    private ServiceContext() {
    }

    public String[] getSupportedTransfers() throws Exception {
        String[] transfers = null;
        try {
            transfers = ((String)this.getProperty("supportedTransfers", new boolean[]{true})).split(",");
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)"No Transfers available");
            throw new Exception("No Transfers available");
        }
        return transfers;
    }

    public static ServiceContext getContext() {
        return cache;
    }

    public String getJNDIName() {
        return JNDI_NAME;
    }

    protected void onInitialisation() throws Exception {
        this.dbConfigurationFileName = (String)this.getProperty("dbConfigurationFile", new boolean[]{true});
        this.setAwsKeyID((String)this.getProperty("awsKeyID", new boolean[]{false}));
        this.setAwsKey((String)this.getProperty("awsKey", new boolean[]{false}));
        this.setConnectionTimeout((Integer)this.getProperty("connectionTimeout", new boolean[]{true}));
        this.setTransferTimeout((Integer)this.getProperty("transferTimeout", new boolean[]{true}));
        this.setRetryLimit((Integer)this.getProperty("retryLimit", new boolean[]{true}));
        this.setVfsRoot((String)this.getProperty("vfsRoot", new boolean[]{true}));
        this.localFSManager = new VFileSystemManager(this.vfsRoot);
        this.setUseMessaging((Boolean)this.getProperty(Constants.USEMESSAGING_JNDI_NAME, new boolean[0]));
        this.dbManager = new DataTransferDBManager();
    }

    public String getVfsRoot() {
        return this.vfsRoot;
    }

    public DataTransferDBManager getDbManager() {
        return this.dbManager;
    }

    public void setDbManager(DataTransferDBManager dbManager) {
        this.dbManager = dbManager;
    }

    protected void onReady() throws Exception {
        super.onReady();
        this.logger.trace((Object)"creating agent resources in all RI scopes");
        ArrayList<PortRange> ports = new ArrayList<PortRange>();
        ports.add(new PortRange(4000, 4050));
        try {
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(), ports, true));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        this.logger.trace((Object)"creating transfer subscription");
        for (Events.TransferTopics topic : Events.TransferTopics.values()) {
            transferEventproducer.subscribe((GCUBEConsumer)new TransferEventConsumer(), (GCUBETopic[])new Events.TransferTopics[]{topic});
        }
    }

    public boolean getUseMessaging() {
        return this.useMessaging;
    }

    public void setUseMessaging(boolean useMessaging) {
        this.useMessaging = useMessaging;
    }

    public String getDbConfigurationFileName() {
        return this.dbConfigurationFileName;
    }

    public void setDbConfigurationFileName(String dbConfigurationFileName) {
        this.dbConfigurationFileName = dbConfigurationFileName;
    }

    public VFileSystemManager getLocalFSManager() {
        return this.localFSManager;
    }

    public String getAwsKeyID() {
        return this.awsKeyID;
    }

    public void setAwsKeyID(String awsKeyID) {
        this.awsKeyID = awsKeyID;
    }

    public String getAwsKey() {
        return this.awsKey;
    }

    public void setAwsKey(String awsKey) {
        this.awsKey = awsKey;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getTransferTimeout() {
        return this.transferTimeout;
    }

    public void setTransferTimeout(int transferTimeout) {
        this.transferTimeout = transferTimeout;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setVfsRoot(String vfsRoot) {
        this.vfsRoot = vfsRoot;
    }
}

