package org.gcube.datatransfer.agent.impl.grs;

import java.util.concurrent.TimeUnit;

import gr.uoa.di.madgik.grs.buffer.IBuffer.Status;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.grs.FileOutcomeRecord;
import org.gcube.datatransfer.common.grs.FileOutcomeRecord.Outcome;

public class GRSOutComeWriter {
	
	GCUBELog logger = new GCUBELog(this.getClass());

	public RecordWriter<GenericRecord> writer=null;
	
	public GRSOutComeWriter(int capacity) throws GRS2WriterException{
		
		writer=new RecordWriter<GenericRecord>(
		        new  TCPWriterProxy(),
		        FileOutcomeRecord.fileOutcomeRecordDef,
		        capacity,
		        2,
		        0.5f
		      );
	}

	public void putField(String sourceUrl, String outURL, Long transferTime,Long transferredBytes,Long total_size,Exception ...e) throws GRS2WriterException {
		logger.debug("Writing Outcome for url: " + sourceUrl);

        if(writer.getStatus()!=Status.Open) return;
          
        GenericRecord recWriter=new GenericRecord();
        
		recWriter.setFields(new Field[]{new StringField(sourceUrl.toString()),
				(e.length!= 0)?new StringField(Outcome.N_A.name()):new StringField(outURL),
        		(e.length!= 0)?new StringField(Outcome.ERROR.name()):new StringField(Outcome.DONE.name()),
        		new StringField(transferTime.toString()),
        		new StringField(transferredBytes.toString()),
        		new StringField(total_size.toString()),
        		(e.length!= 0)?new StringField(e[0].getMessage()):new StringField(Outcome.N_A.name())
        				});
        //if the buffer is in maximum capacity for the specified interval don;t wait any more
        if (!writer.put(recWriter,60,TimeUnit.SECONDS)) return;
        else
        	logger.debug("Succesfully written Outcome for url: " + sourceUrl);
   
	}
	
	public RecordWriter<GenericRecord> getWriter() {
		return writer;
	}

	public void setWriter(RecordWriter<GenericRecord> writer) {
		this.writer = writer;
	}
	
	public void close () throws GRS2WriterException{
		writer.close();
	}
	
}
