/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.event.TransferRequestListener;
import org.gcube.datatransfer.agent.impl.utils.Utils;
import org.gcube.datatransfer.common.messaging.BrokerSubscription;
import org.gcube.datatransfer.common.messaging.messages.TransferRequestMessage;

public class TransferRequestSubscription
extends BrokerSubscription<TransferRequestListener> {
    private GCUBELog logger = new GCUBELog(TransferRequestSubscription.class);

    public TransferRequestSubscription(String subscriberEndpoint) {
        super(subscriberEndpoint);
    }

    public void setScope(GCUBEScope scope) {
        BrokerSubscription.DestinationPair pair = new BrokerSubscription.DestinationPair((BrokerSubscription)this);
        pair.setScope(scope);
        String topic = null;
        if (scope.isInfrastructure()) {
            topic = Utils.replaceUnderscore(scope.getName()) + "." + TransferRequestMessage.dataTransferLabel + "." + this.subscriberEndpoint + ".*";
        } else if (scope.getType().compareTo((Enum)GCUBEScope.Type.VO) == 0) {
            String voName = scope.getName();
            topic = Utils.replaceUnderscore(scope.getInfrastructure().getName()) + "." + voName + "." + TransferRequestMessage.dataTransferLabel + "." + this.subscriberEndpoint + ".*";
        }
        pair.setDestinationName(topic);
        pair.setQueue(true);
        this.setDestinationPair(pair);
        this.logger.debug((Object)("TransferRequestSubscription - topic=" + topic));
        this.listener = new TransferRequestListener(scope, this.subscriberEndpoint);
    }
}

