/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.porttype;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.tml.proxies.BindRequest;
import org.gcube.data.tml.proxies.Binding;
import org.gcube.data.tml.proxies.TBinder;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.tr.requests.BindSource;
import org.gcube.datatransfer.agent.impl.context.AgentContext;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.db.DataTransferDBManager;
import org.gcube.datatransfer.agent.impl.state.AgentResource;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.SyncWorker;
import org.gcube.datatransfer.agent.impl.worker.Worker;
import org.gcube.datatransfer.agent.impl.worker.async.DataStorageASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.async.LocalFileTransferASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.async.StorageManagerASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.async.TreeManagerAsyncWorker;
import org.gcube.datatransfer.agent.impl.worker.sync.LocalFileTransferSyncWorker;
import org.gcube.datatransfer.agent.impl.worker.sync.LocalTransferSyncWorker;
import org.gcube.datatransfer.agent.impl.worker.sync.StorageManagerSyncWorker;
import org.gcube.datatransfer.agent.impl.worker.sync.TreeManagerSyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CreateTreeSourceMsg;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.GetTransferOutcomesFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.MonitorTransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.MonitorTransferReportMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StartTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.objs.LocalSource;
import org.gcube.datatransfer.common.objs.LocalSources;
import org.gcube.datatransfer.common.outcome.TransferStatus;
import org.gcube.datatransfer.common.utils.Utils;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class DataTransferAgent
extends GCUBEPortType {
    protected final GCUBELog logger = new GCUBELog(DataTransferAgent.class);
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();

    public AgentResource getResource() throws Exception {
        return AgentContext.getContext().getAgent();
    }

    public String startTransfer(StartTransferMessage message) throws TransferFault {
        this.logger.info((Object)("Start Transfer invoked in scope " + message.getSource().getScope()));
        String id = uuidgen.nextUUID();
        try {
            if (message.getSource().getType().getValue().compareTo(TransferType.LocalFileBasedTransfer.getValue()) == 0) {
                this.logger.debug((Object)("Local transfer from  URI :" + message.getSource().getInputURIs()[0]));
                LocalTransferSyncWorker worker = new LocalTransferSyncWorker(id, message.getSource(), message.getDest());
                return (String)worker.call();
            }
            if (message.isSyncOp()) {
                this.logger.debug((Object)"Sync operation");
                this.logger.debug((Object)("TransferType: " + message.getSource().getType().getValue()));
                return this.startSyncTask(id, message.getSource(), message.getDest());
            }
            this.logger.debug((Object)"ASync operation");
            this.logger.debug((Object)("TransferType: " + message.getSource().getType().getValue()));
            FutureTask<Worker> task = this.startAsyncTask(id, message.getSource(), message.getDest());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to perform the transfer", (Throwable)e);
            throw (TransferFault)Utils.newFault((GCUBEFault)new TransferFault(), (Throwable)e);
        }
        this.logger.debug((Object)("Returning id : " + id));
        return id;
    }

    public String cancelTransfer(CancelTransferMessage message) throws CancelTransferFault {
        String handlerID = message.getTransferID();
        if (handlerID == null) {
            throw (CancelTransferFault)Utils.newFault((GCUBEFault)new CancelTransferFault(), (Throwable)new Exception("The Transfer ID is null"));
        }
        FutureTask futureTask = null;
        Worker worker = null;
        AgentResource.FutureWorker futureWorker = null;
        try {
            futureWorker = this.getResource().getWorkerMap().get(handlerID);
            if (futureWorker != null) {
                futureTask = futureWorker.getFutureTask();
                worker = futureWorker.getWorker();
                if (futureTask == null) {
                    this.logger.debug((Object)"null futureTask");
                } else if (worker == null) {
                    this.logger.debug((Object)"null worker");
                } else {
                    if (worker.getThreadList() == null) {
                        this.logger.debug((Object)"null threadList");
                    } else {
                        worker.getThreadList().stop();
                    }
                    futureTask.cancel(message.isForceStop());
                }
            } else {
                this.logger.debug((Object)"null futureWorker");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to cancel the transfer", (Throwable)e);
            throw (CancelTransferFault)Utils.newFault((GCUBEFault)new CancelTransferFault(), (Throwable)e);
        }
        finally {
            try {
                if (!ServiceContext.getContext().getDbManager().checkIfTransferExist(handlerID)) {
                    this.logger.debug((Object)("cancelTransfer - transfer with id=" + handlerID + " does not exist"));
                    return handlerID;
                }
                this.getResource().getWorkerMap().remove(handlerID);
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(handlerID, TransferStatus.CANCEL.name());
            }
            catch (Exception e) {
                throw (CancelTransferFault)Utils.newFault((GCUBEFault)new CancelTransferFault(), (Throwable)e);
            }
        }
        return handlerID;
    }

    public FutureTask<Worker> startAsyncTask(String id, SourceData source, DestData dest) throws Exception {
        this.logger.debug((Object)"startAsyncTask has been reached ... ");
        ASyncWorker worker = null;
        FutureTask<Worker> task = null;
        DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();
        if (source.getType().getValue().compareTo(TransferType.TreeBasedTransfer.getValue()) == 0) {
            worker = new TreeManagerAsyncWorker(id, source, dest);
            if (dbManager.checkIfTransferExist(id)) {
                dbManager.updateTransfer(id);
            } else {
                dbManager.storeTransfer(TransferUtils.createTransferJDO(id, source.getInputSource().getSourceId(), dest.getOutSourceId()));
            }
        } else if (source.getType().getValue().compareTo(TransferType.FileBasedTransfer.getValue()) == 0) {
            worker = dest.getOutUri().getOptions().getStorageType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0 ? new StorageManagerASyncWorker(id, source, dest) : (dest.getOutUri().getOptions().getStorageType().getValue().compareTo(StorageType.DataStorage.getValue()) == 0 ? new DataStorageASyncWorker(id, source, dest) : new LocalFileTransferASyncWorker(id, source, dest));
            if (dbManager.checkIfTransferExist(id)) {
                dbManager.updateTransfer(id);
            } else {
                dbManager.storeTransfer(TransferUtils.createTransferJDO(id));
            }
        }
        task = new FutureTask<Worker>(worker);
        worker.setTask(task);
        Thread t = new Thread(task);
        t.start();
        AgentResource.FutureWorker futureWorker = new AgentResource.FutureWorker();
        futureWorker.setFutureTask(task);
        futureWorker.setWorker(worker);
        this.getResource().getWorkerMap().put(id, futureWorker);
        return task;
    }

    private String startSyncTask(String id, SourceData source, DestData dest) throws Exception {
        SyncWorker worker = null;
        FutureTask task = null;
        if (source.getType().getValue().compareTo(TransferType.TreeBasedTransfer.getValue()) == 0) {
            worker = new TreeManagerSyncWorker(id, source, dest);
            worker.call();
            return ((SyncWorker)worker).getOutcomeLocator();
        }
        if (source.getType().getValue().compareTo(TransferType.FileBasedTransfer.getValue()) == 0) {
            worker = dest.getOutUri().getOptions().getStorageType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0 ? new StorageManagerSyncWorker(id, source, dest) : new LocalFileTransferSyncWorker(id, source, dest);
        }
        task = new FutureTask(worker);
        Thread t = new Thread(task);
        t.start();
        return ((SyncWorker)worker).getOutcomeLocator();
    }

    public String monitorTransfer(String transferId) throws MonitorTransferFault {
        if (transferId == null) {
            throw (MonitorTransferFault)Utils.newFault((GCUBEFault)new MonitorTransferFault(), (Throwable)new Exception("The Transfer ID is null"));
        }
        String status = "";
        try {
            status = ServiceContext.getContext().getDbManager().getTransferStatus(transferId);
        }
        catch (Exception e) {
            throw (MonitorTransferFault)Utils.newFault((GCUBEFault)new MonitorTransferFault(), (Throwable)e);
        }
        return status;
    }

    public String getTransferOutcomes(String transferId) throws GetTransferOutcomesFault {
        if (transferId == null) {
            throw (GetTransferOutcomesFault)Utils.newFault((GCUBEFault)new GetTransferOutcomesFault(), (Throwable)new Exception("The Transfer ID is null"));
        }
        String rs = "";
        try {
            rs = ServiceContext.getContext().getDbManager().getTransferObjectOutComeAsRS(transferId);
        }
        catch (Exception e) {
            if (e.getMessage().compareTo("The Transfer Objects list is empty") == 0) {
                return null;
            }
            e.printStackTrace();
            throw (GetTransferOutcomesFault)Utils.newFault((GCUBEFault)new GetTransferOutcomesFault(), (Throwable)e);
        }
        return rs;
    }

    public String getLocalSources(String filePath) {
        String vfsRoot = (String)ServiceContext.getContext().getProperty("vfsRoot", new boolean[]{true});
        if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        String path = null;
        path = !vfsRoot.endsWith("/") && !filePath.startsWith("/") ? vfsRoot + "/" + filePath : vfsRoot + filePath;
        LocalSources sources = new LocalSources();
        ArrayList<LocalSource> list = new ArrayList<LocalSource>();
        File main = new File(path);
        if (!main.isDirectory()) {
            return null;
        }
        String[] children = main.list();
        if (children != null && children.length > 0) {
            for (String tmp : children) {
                File child = new File(path + tmp);
                if (child.isDirectory()) {
                    LocalSource dir = new LocalSource();
                    dir.setDirectory(true);
                    dir.setPath(child.getAbsolutePath());
                    dir.setVfsRoot(vfsRoot);
                    list.add(dir);
                    continue;
                }
                LocalSource file = new LocalSource();
                file.setDirectory(false);
                file.setPath(child.getAbsolutePath());
                file.setVfsRoot(vfsRoot);
                file.setSize(child.length());
                list.add(file);
            }
        }
        sources.setList(list);
        return sources.toXML();
    }

    public String createTreeSource(CreateTreeSourceMsg msg) {
        try {
            BindSource request;
            BindRequest params;
            Binding binding;
            String id;
            if (msg == null) {
                this.logger.error((Object)"input CreateTreeSourceMsg is null");
                return null;
            }
            String sourceID = msg.getSourceID();
            String endpoint = msg.getEndpoint();
            int port = msg.getPort();
            TBinder binder = null;
            if (endpoint == null) {
                this.logger.debug((Object)"not specific endpoint");
                binder = (TBinder)TServiceFactory.binder().matching((org.gcube.common.clients.queries.Query)TServiceFactory.plugin((String)"tree-repository")).build();
            } else {
                this.logger.debug((Object)("specific endpoint: " + endpoint + ":" + port));
                binder = (TBinder)TServiceFactory.binder().at(endpoint, port).build();
            }
            if (binder == null) {
                this.logger.error((Object)"binder is null");
                return null;
            }
            if (sourceID == null) {
                this.logger.debug((Object)"sourceID was not given, create a random one");
                sourceID = uuidgen.nextUUID();
            }
            if ((id = (binding = (Binding)binder.bind(params = new BindRequest("tree-repository", (request = new BindSource(sourceID)).toElement())).get(0)).source()) != null) {
                this.logger.debug((Object)("tree source='" + id + "' has been created.."));
            } else {
                this.logger.debug((Object)("creation of tree source='" + id + "' returned null!!"));
            }
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String removeGenericResource(String id) {
        try {
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/ID/text() eq '" + id + "'");
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            List resources = client.submit((Query)query);
            RegistryPublisher rp = RegistryPublisherFactory.create();
            for (GenericResource resource : resources) {
                rp.remove((Resource)resource);
            }
            return "OK";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTreeSources(String type) {
        try {
            String scope = ScopeProvider.instance.get();
            ArrayList<String> gresources = new ArrayList<String>();
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            if (client == null) {
                this.logger.error((Object)"client=null");
                return null;
            }
            WSResourceQuery WSquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            List docList = client.execute((ISQuery)WSquery, GCUBEScope.getScope((String)scope));
            if (docList != null) {
                if (type != null) {
                    this.logger.debug((Object)("getTreeSources - type=" + type));
                } else {
                    this.logger.debug((Object)"getTreeSources - type=both readers and writers");
                }
            } else {
                this.logger.error((Object)"getTreeSources -list from query=null");
                return null;
            }
            for (RPDocument resource : docList) {
                if (resource.getServiceClass() == null || resource.getServiceClass().compareTo("DataAccess") != 0 || resource.getServiceName() == null || resource.getServiceName().compareTo("tree-manager-service") != 0 || !resource.getEndpoint().getAddress().toString().endsWith("reader") && !resource.getEndpoint().getAddress().toString().endsWith("writer") || type != null && !resource.getEndpoint().getAddress().toString().endsWith(type)) continue;
                int num = 0;
                String cardinality = org.gcube.datatransfer.agent.impl.utils.Utils.getParameterFromWSResource(resource, "Cardinality");
                if (!cardinality.startsWith("no_")) {
                    try {
                        num = Integer.valueOf(cardinality);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        num = 0;
                    }
                }
                if (resource.getEndpoint().getAddress().toString().endsWith("reader") && num < 1) continue;
                String id = resource.getKey().getValue();
                String name = org.gcube.datatransfer.agent.impl.utils.Utils.getParameterFromWSResource(resource, "Name");
                String treeSource = id + "--" + name + "--" + num;
                this.logger.debug((Object)("treeSource=" + treeSource));
                gresources.add(treeSource);
            }
            XStream xstreamClient = new XStream();
            return xstreamClient.toXML(gresources);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MonitorTransferReportMessage monitorTransferWithProgress(String transferId) throws MonitorTransferFault {
        if (transferId == null) {
            throw (MonitorTransferFault)Utils.newFault((GCUBEFault)new MonitorTransferFault(), (Throwable)new Exception("The Transfer ID is null"));
        }
        MonitorTransferReportMessage message = null;
        try {
            message = ServiceContext.getContext().getDbManager().getTrasferProgress(transferId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (MonitorTransferFault)Utils.newFault((GCUBEFault)new MonitorTransferFault(), (Throwable)e);
        }
        return message;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

