/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.messaging;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.messaging.endpoints.BrokerEndpoints;
import org.gcube.common.messaging.endpoints.BrokerNotConfiguredInScopeException;
import org.gcube.common.messaging.endpoints.ScheduledRetriever;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionsManager {
    private static long refreshTime = 1800L;
    private static long waitingTime = 60L;
    static Logger logger = LoggerFactory.getLogger(ConnectionsManager.class);
    private static HashMap<GCUBEScope, ActiveMQConnectionFactory> connectionFactoryMap = null;
    private static HashMap<GCUBEScope, TopicConnection> topicConnectionMap = null;
    private static HashMap<GCUBEScope, QueueConnection> queueConnectionMap = null;

    public void init(long waitingTime, long refreshTime) {
        ConnectionsManager.refreshTime = refreshTime;
        ConnectionsManager.waitingTime = waitingTime;
    }

    public static TopicConnection getTopicConnection(GCUBEScope scope) {
        TopicConnection connection = topicConnectionMap.get(scope);
        if (connection == null) {
            logger.debug("CONNECTION MAP NULL");
        }
        return connection;
    }

    public static QueueConnection getQueueConnection(GCUBEScope scope) {
        QueueConnection connection = queueConnectionMap.get(scope);
        if (connection == null) {
            logger.debug("CONNECTION MAP NULL");
        }
        return connection;
    }

    public static synchronized void addScope(GCUBEScope scope) throws BrokerNotConfiguredInScopeException, Exception {
        ScopeProvider.instance.set(scope.toString());
        BrokerEndpoints.getRetriever((long)waitingTime, (long)refreshTime);
        ConnectionsManager.reloadConnection(scope);
    }

    public static ScheduledRetriever getBrokerRetriever(GCUBEScope scope) throws BrokerNotConfiguredInScopeException, Exception {
        ScopeProvider.instance.set(scope.toString());
        return BrokerEndpoints.getRetriever((long)waitingTime, (long)refreshTime);
    }

    public static synchronized void reloadConnection(GCUBEScope scope) {
        ConnectionsManager.stopConnections(scope);
        ActiveMQConnectionFactory factory = null;
        TopicConnection connection = null;
        QueueConnection queueConnection = null;
        logger.debug("Reload JMS connections");
        try {
            logger.info("MSG-Broker failover endpoint found: " + ConnectionsManager.getBrokerRetriever(scope).getFailoverEndpoint() + " for scope: " + scope.toString());
            factory = new ActiveMQConnectionFactory(ConnectionsManager.getBrokerRetriever(scope).getFailoverEndpoint());
            connection = factory.createTopicConnection();
            connection.start();
            queueConnection = factory.createQueueConnection();
            queueConnection.start();
        }
        catch (JMSException e1) {
            logger.error("Error creating Topic Connection", (Throwable)e1);
        }
        catch (Exception e) {
            logger.error("Error creating Topic Connection", (Throwable)e);
        }
        topicConnectionMap.put(scope, connection);
        queueConnectionMap.put(scope, queueConnection);
        connectionFactoryMap.put(scope, factory);
    }

    public static boolean checkStartScope(GCUBEScope scope) {
        boolean isStartScope = false;
        for (GCUBEScope scopeStart : GHNContext.getContext().getStartScopes()) {
            if (!scope.equals((Object)scopeStart) && !scope.isInfrastructure()) continue;
            isStartScope = true;
        }
        return isStartScope;
    }

    private static void stopConnections(GCUBEScope scope) {
        TopicConnection con;
        if (topicConnectionMap != null && topicConnectionMap.get(scope) != null) {
            con = topicConnectionMap.get(scope);
            try {
                con.stop();
                con.close();
            }
            catch (JMSException e) {
                logger.error("Error stopping topicConnections", (Throwable)e);
            }
        }
        if (queueConnectionMap != null && queueConnectionMap.get(scope) != null) {
            con = queueConnectionMap.get(scope);
            try {
                con.stop();
                con.close();
            }
            catch (JMSException e) {
                logger.error("Error stopping queueConnections", (Throwable)e);
            }
        }
    }

    static {
        connectionFactoryMap = new HashMap();
        topicConnectionMap = new HashMap();
        queueConnectionMap = new HashMap();
    }
}

