/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.datatransfer.common.messaging.TransferMessage;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class MSGClient {
    protected MSGClient() throws IOException, GCUBEScopeNotSupportedException {
        if (this.isClientMode()) {
            this.startLocalProducer(GCUBEScope.getScope((String)("/" + GHNContext.getContext().getProperty("infrastructure", new boolean[]{true}))));
        }
    }

    public void sendMessage(GCUBEServiceContext context, TransferMessage message, GCUBEScope ... scope) throws GHNClientModeException, IllegalArgumentException, Exception {
        if (this.isClientMode()) {
            throw new GHNClientModeException("Container is not running, this method is not intented to be used in GHN client mode");
        }
        try {
            message.setTimeNow();
            if (scope.length > 0) {
                message.createTopicName(scope[0].getInfrastructure());
                message.setScope(scope[0].getInfrastructure().toString());
                GCUBELocalProducer.logger.debug((Object)message.toString());
                this.sendMessage(message);
            } else {
                for (GCUBEScope sco : context.getInstance().getScopes().values()) {
                    message.createTopicName(sco.getInfrastructure());
                    message.setScope(sco.getInfrastructure().toString());
                    GCUBELocalProducer.logger.debug((Object)message.toString());
                    this.sendMessage(message);
                }
            }
        }
        catch (Exception e) {
            GCUBELocalProducer.logger.error((Object)"Error Sending Transfer message", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    private boolean isClientMode() {
        return GHNContext.getContext().isClientMode();
    }

    private void sendMessage(GCUBEMessage message) {
        ActiveMQClient.getSingleton().sendMessageToQueue(message);
    }

    private void startLocalProducer(GCUBEScope scope) throws GCUBEScopeNotSupportedException {
        GCUBELocalProducer local = new GCUBELocalProducer();
        long interval = 1200L;
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        if (scope.getServiceMap().getEndpoints((Object)"MessageBroker") != null) {
            for (EndpointReferenceType msgBrokerEpr : scope.getServiceMap().getEndpoints((Object)"MessageBroker")) {
                eprs.add(msgBrokerEpr);
            }
        }
        HashMap<GCUBEScope, ArrayList<EndpointReferenceType>> monitoredScopes = new HashMap<GCUBEScope, ArrayList<EndpointReferenceType>>();
        monitoredScopes.put(scope, eprs);
        local.setBrokerMap(monitoredScopes);
        local.setInterval(interval);
        local.run();
    }

    class GHNClientModeException
    extends Exception {
        private static final long serialVersionUID = 2107643850291448530L;

        public GHNClientModeException(String string) {
            super(string);
        }
    }
}

