package org.gcube.data.transfer.library.client;

import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;

import lombok.extern.slf4j.Slf4j;

import org.gcube.data.transfer.model.ServiceConstants;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.glassfish.jersey.client.ClientConfig;

@Slf4j
public class Client {

	private static ClientConfig config=null;
	
	static{
		log.debug("Creating configuration ..");
		config=new ClientConfig();
		config.register(AuthorizationFilter.class);
		config.register(JAXBElement.class);
	}
	
	private String endpoint;

	private WebTarget rootTarget;
	
	public Client(String endpoint){
		log.debug("Creating client for base "+endpoint);
		this.endpoint=endpoint+"";
		rootTarget= ClientBuilder.newClient(config).target(endpoint).path("/data-transfer-service/").path(ServiceConstants.APPLICATION_PATH);		
	}
	
	
	public String getEndpoint() {
		return endpoint;
	}
	
	public TransferCapabilities getCapabilties(){
		log.debug("Getting capabilities to {} ",endpoint);
		return rootTarget.path(ServiceConstants.CAPABILTIES_SERVLET_NAME).request(MediaType.APPLICATION_XML_TYPE).get(TransferCapabilities.class);
	}
	
	
	public TransferTicket submit(TransferRequest request){
		log.debug("Sending request {} to {}",request,endpoint);
		return rootTarget.path(ServiceConstants.REQUESTS_SERVLET_NAME).request(MediaType.APPLICATION_XML_TYPE).post(Entity.entity(request,MediaType.APPLICATION_XML),TransferTicket.class);
	}
	
	public TransferTicket getTransferStatus(String transferId){
		log.debug("Requesting transfer status [id = {}, endpoint={}]",transferId,endpoint);
		return rootTarget.path(ServiceConstants.STATUS_SERVLET_NAME).path(transferId).request(MediaType.APPLICATION_XML).get(TransferTicket.class);
	}
}
