/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.transferers;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.data.transfer.library.client.Client;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.model.LocalSource;
import org.gcube.data.transfer.library.model.StorageSource;
import org.gcube.data.transfer.library.model.URLSource;
import org.gcube.data.transfer.library.transferers.Transferer;
import org.gcube.data.transfer.library.utils.StorageUtils;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.options.HttpDownloadOptions;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.model.settings.TransferSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPTransferer
extends Transferer {
    private static final Logger log = LoggerFactory.getLogger(HTTPTransferer.class);
    private URL link;
    private String toDeleteStorageId = null;

    HTTPTransferer(Client client) {
        super(client);
    }

    @Override
    protected TransferRequest prepareRequest() throws InitializationException {
        return new TransferRequest("", (TransferSettings)new HttpDownloadSettings(this.link, HttpDownloadOptions.DEFAULT));
    }

    private URL getHttpLink() throws RemoteBackendException, FileNotFoundException, InvalidSourceException, MalformedURLException {
        if (this.source instanceof LocalSource) {
            this.toDeleteStorageId = StorageUtils.putOntoStorage(((LocalSource)this.source).getTheSource());
            return new URL(StorageUtils.getUrlById(this.toDeleteStorageId));
        }
        if (this.source instanceof StorageSource) {
            return new URL(StorageUtils.getUrlById(((StorageSource)this.source).getTheSource()));
        }
        if (this.source instanceof URLSource) {
            return ((URLSource)this.source).getTheSource();
        }
        throw new InvalidSourceException("Source cannot be handled " + this.source);
    }

    @Override
    protected void prepare() throws InitializationException {
        try {
            this.link = this.getHttpLink();
            log.debug("Obtained link " + this.link);
            super.prepare();
        }
        catch (RemoteBackendException e) {
            throw new InitializationException(e);
        }
        catch (FileNotFoundException e) {
            throw new InitializationException(e);
        }
        catch (InvalidSourceException e) {
            throw new InitializationException(e);
        }
        catch (MalformedURLException e) {
            throw new InitializationException(e);
        }
    }

    @Override
    protected void clean() {
        super.clean();
    }
}

