/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.transferers;

import java.io.File;
import java.net.URL;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.client.Client;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.library.model.LocalSource;
import org.gcube.data.transfer.library.model.Source;
import org.gcube.data.transfer.library.model.StorageSource;
import org.gcube.data.transfer.library.model.URLSource;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Transferer {
    private static final Logger log = LoggerFactory.getLogger(Transferer.class);
    protected Client client;
    protected Source source = null;
    protected boolean prepared = false;

    protected Transferer(Client client) {
        this.client = client;
    }

    public Transferer localFile(File f) throws InvalidSourceException {
        this.source = new LocalSource(f);
        return this;
    }

    public Transferer localFile(String path) throws InvalidSourceException {
        try {
            File f = new File(path);
            return this.localFile(f);
        }
        catch (NullPointerException e) {
            throw new InvalidSourceException("Path is null", e);
        }
    }

    public Transferer storageFileId(String fileId) throws InvalidSourceException {
        this.source = new StorageSource(fileId);
        return this;
    }

    public Transferer fromURL(URL sourceURL) throws InvalidSourceException {
        this.source = new URLSource(sourceURL);
        return this;
    }

    public TransferResult transfer() throws SourceNotSetException, InvalidSourceException, FailedTransferException, InitializationException {
        try {
            TransferResult result;
            this.checkSource();
            this.prepare();
            TransferRequest request = this.prepareRequest();
            log.debug("Request is {}, sending it to {}", (Object)request, (Object)this.client.getEndpoint());
            TransferResult transferResult = result = this.doTheTransfer(request);
            return transferResult;
        }
        finally {
            this.clean();
        }
    }

    protected TransferResult doTheTransfer(TransferRequest request) throws FailedTransferException {
        TransferTicket submissionResponse = this.client.submit(request);
        boolean continuePolling = true;
        TransferTicket ticket = null;
        do {
            ticket = this.client.getTransferStatus(submissionResponse.getId());
            System.out.println("Status : " + ticket);
            continuePolling = ticket.getStatus().equals((Object)TransferTicket.Status.PENDING) || ticket.getStatus().equals((Object)TransferTicket.Status.TRANSFERRING) || ticket.getStatus().equals((Object)TransferTicket.Status.WAITING);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (continuePolling);
        if (ticket.getStatus().equals((Object)TransferTicket.Status.ERROR)) {
            throw new FailedTransferException("Remote Message : " + ticket.getMessage());
        }
        if (ticket.getStatus().equals((Object)TransferTicket.Status.STOPPED)) {
            throw new FailedTransferException("Stopped transfer : " + ticket.getMessage());
        }
        long elapsedTime = System.currentTimeMillis() - ticket.getSubmissionTime().value.getTimeInMillis();
        return new TransferResult(this.source, this.client.getEndpoint(), elapsedTime, ticket.getTransferredBytes(), ticket.getDestinationFileName());
    }

    protected void checkSource() throws SourceNotSetException, InvalidSourceException {
        if (this.source == null) {
            throw new SourceNotSetException();
        }
        this.source.validate();
    }

    protected abstract TransferRequest prepareRequest() throws InitializationException;

    protected void prepare() throws InitializationException {
        this.prepared = true;
    }

    protected void clean() {
    }

    public TransferCapabilities getDestinationCapabilities() {
        return this.client.getCapabilties();
    }
}

