/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.transferers;

import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.data.transfer.library.caches.CapabilitiesCache;
import org.gcube.data.transfer.library.client.Client;
import org.gcube.data.transfer.library.faults.HostingNodeNotFoundException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.library.transferers.HTTPTransferer;
import org.gcube.data.transfer.library.transferers.Transferer;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransfererBuilder {
    private static final Logger log = LoggerFactory.getLogger(TransfererBuilder.class);
    private static final int timeout = 10000;

    public static Transferer getTransfererByHost(String endpoint) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Get transferer by Host " + endpoint);
        try {
            URL url = new URL(endpoint);
            String baseUrl = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort();
            TransferCapabilities cap = (TransferCapabilities)CapabilitiesCache.getInstance().getObject(baseUrl);
            return new HTTPTransferer(new Client(baseUrl));
        }
        catch (MalformedURLException e) {
            throw new ServiceNotFoundException(e);
        }
    }

    public static Transferer getTransfererByhostingNodeId(String hostId) throws HostingNodeNotFoundException, UnreachableNodeException, ServiceNotFoundException {
        String hostname = TransfererBuilder.retrieveHostnameByNodeId(hostId);
        return TransfererBuilder.getTransfererByHost(hostname);
    }

    private static String retrieveHostnameByNodeId(String nodeId) throws HostingNodeNotFoundException {
        return null;
    }
}

