/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.model.utils;

import java.beans.ConstructorProperties;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.gcube.data.transfer.model.utils.DateFormatterAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DateWrapper {
    private static final Logger log = LoggerFactory.getLogger(DateWrapper.class);
    static DatatypeFactory factory = null;
    @XmlJavaTypeAdapter(value=DateFormatterAdapter.class)
    @XmlElement
    public Calendar value;

    public static DateWrapper getInstance() {
        return new DateWrapper(Calendar.getInstance());
    }

    public String toString() {
        if (this.value != null) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(this.value.getTime());
            XMLGregorianCalendar date2 = factory.newXMLGregorianCalendar(c);
            return date2.toXMLFormat();
        }
        return "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateWrapper other = (DateWrapper)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @ConstructorProperties(value={"value"})
    public DateWrapper(Calendar value) {
        this.value = value;
    }

    public DateWrapper() {
    }

    public void setValue(Calendar value) {
        this.value = value;
    }

    public Calendar getValue() {
        return this.value;
    }

    static {
        try {
            factory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            log.error("Unexpected exception ", (Throwable)e);
        }
    }
}

