/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.model;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.utils.DateWrapper;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TransferTicket
extends TransferRequest {
    @XmlElement
    private Status status;
    @XmlElement
    private long transferredBytes;
    @XmlElement
    private double percent;
    @XmlElement
    private long averageTransferSpeed;
    @XmlElement
    private DateWrapper submissionTime;
    @XmlElement
    private String destinationFileName;
    @XmlElement
    private String message;
    @XmlElement
    private Map<String, ExecutionReport> executionReports;

    public TransferTicket(TransferRequest request, Status status, long transferredBytes, double percent, long averageTransferSpeed, DateWrapper submissionTime, String destinationFileName, String message, Map<String, ExecutionReport> executionReports) {
        super(request.getId(), request.getSettings(), request.getDestinationSettings(), request.getPluginInvocations());
        this.status = status;
        this.transferredBytes = transferredBytes;
        this.percent = percent;
        this.averageTransferSpeed = averageTransferSpeed;
        this.submissionTime = submissionTime;
        this.destinationFileName = destinationFileName;
        this.executionReports = executionReports;
    }

    public TransferTicket(TransferRequest request) {
        super(request.getId(), request.getSettings(), request.getDestinationSettings(), request.getPluginInvocations());
        this.status = Status.PENDING;
        this.transferredBytes = 0L;
        this.averageTransferSpeed = 0L;
        this.destinationFileName = "/dev/null";
        this.percent = 0.0;
        this.submissionTime = DateWrapper.getInstance();
        this.message = "";
        this.executionReports = new HashMap<String, ExecutionReport>();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferTicket other = (TransferTicket)obj;
        if (this.averageTransferSpeed != other.averageTransferSpeed) {
            return false;
        }
        if (this.destinationFileName == null ? other.destinationFileName != null : !this.destinationFileName.equals(other.destinationFileName)) {
            return false;
        }
        if (this.executionReports == null || this.executionReports.isEmpty()) {
            if (other.executionReports != null && !other.executionReports.isEmpty()) {
                return false;
            }
            if (this.executionReports != null && !this.executionReports.isEmpty()) {
                if (other.executionReports == null || other.executionReports.isEmpty()) {
                    return false;
                }
                if (this.executionReports.size() != other.executionReports.size()) {
                    return false;
                }
                for (String key : this.executionReports.keySet()) {
                    if (other.executionReports.containsKey(key) && this.executionReports.get(key).equals(other.executionReports.get(key))) continue;
                    return false;
                }
            }
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (Double.doubleToLongBits(this.percent) != Double.doubleToLongBits(other.percent)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.submissionTime == null ? other.submissionTime != null : !this.submissionTime.equals(other.submissionTime)) {
            return false;
        }
        return this.transferredBytes == other.transferredBytes;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.averageTransferSpeed ^ this.averageTransferSpeed >>> 32);
        result = 31 * result + (this.destinationFileName == null ? 0 : this.destinationFileName.hashCode());
        if (this.executionReports != null) {
            for (Map.Entry<String, ExecutionReport> entry : this.executionReports.entrySet()) {
                result = 31 * result + (entry.getKey().hashCode() + entry.getValue().hashCode());
            }
        }
        result = 31 * result + (this.executionReports == null ? 0 : this.executionReports.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        long temp = Double.doubleToLongBits(this.percent);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.submissionTime == null ? 0 : this.submissionTime.hashCode());
        result = 31 * result + (int)(this.transferredBytes ^ this.transferredBytes >>> 32);
        return result;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public double getPercent() {
        return this.percent;
    }

    public long getAverageTransferSpeed() {
        return this.averageTransferSpeed;
    }

    public DateWrapper getSubmissionTime() {
        return this.submissionTime;
    }

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, ExecutionReport> getExecutionReports() {
        return this.executionReports;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTransferredBytes(long transferredBytes) {
        this.transferredBytes = transferredBytes;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public void setAverageTransferSpeed(long averageTransferSpeed) {
        this.averageTransferSpeed = averageTransferSpeed;
    }

    public void setSubmissionTime(DateWrapper submissionTime) {
        this.submissionTime = submissionTime;
    }

    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setExecutionReports(Map<String, ExecutionReport> executionReports) {
        this.executionReports = executionReports;
    }

    @Override
    public String toString() {
        return "TransferTicket(status=" + (Object)((Object)this.getStatus()) + ", transferredBytes=" + this.getTransferredBytes() + ", percent=" + this.getPercent() + ", averageTransferSpeed=" + this.getAverageTransferSpeed() + ", submissionTime=" + this.getSubmissionTime() + ", destinationFileName=" + this.getDestinationFileName() + ", message=" + this.getMessage() + ", executionReports=" + this.getExecutionReports() + ")";
    }

    public TransferTicket() {
    }

    @ConstructorProperties(value={"status", "transferredBytes", "percent", "averageTransferSpeed", "submissionTime", "destinationFileName", "message", "executionReports"})
    public TransferTicket(Status status, long transferredBytes, double percent, long averageTransferSpeed, DateWrapper submissionTime, String destinationFileName, String message, Map<String, ExecutionReport> executionReports) {
        this.status = status;
        this.transferredBytes = transferredBytes;
        this.percent = percent;
        this.averageTransferSpeed = averageTransferSpeed;
        this.submissionTime = submissionTime;
        this.destinationFileName = destinationFileName;
        this.message = message;
        this.executionReports = executionReports;
    }

    @XmlEnum
    public static enum Status {
        PENDING,
        WAITING,
        TRANSFERRING,
        SUCCESS,
        ERROR,
        STOPPED,
        PLUGIN_EXECUTION;

    }
}

