/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.faults.DestinationAccessException;
import org.gcube.data.transfer.service.transfers.engine.faults.ManagedException;
import org.gcube.data.transfer.service.transfers.engine.faults.NotSupportedMethodException;
import org.gcube.data.transfer.service.transfers.engine.impl.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private TransferTicket ticket;
    private PersistenceProvider persistenceProvider;
    private TicketManager manager;

    public RequestHandler(TransferRequest servingRequest, TicketManager manager, PersistenceProvider persistenceProvider) {
        this.ticket = new TransferTicket(servingRequest);
        log.debug("Created Handler, request is : " + servingRequest);
        this.manager = manager;
        this.persistenceProvider = persistenceProvider;
        manager.insertUpdate(this.ticket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.trace("Request handling started. Ticket is " + this.ticket);
            switch (1.$SwitchMap$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod[this.ticket.getSettings().getOptions().getMethod().ordinal()]) {
                case 1: {
                    throw new NotSupportedMethodException("Unable to manage request [ID " + this.ticket.getId() + "]. Method not supported : " + this.ticket.getSettings().getOptions().getMethod());
                }
                case 2: {
                    File output = null;
                    BufferedInputStream in = null;
                    BufferedOutputStream out = null;
                    boolean complete = false;
                    try {
                        this.updateTicket("Opening connection", 0.0, TransferTicket.Status.TRANSFERRING, 0L);
                        HttpDownloadSettings options = (HttpDownloadSettings)this.ticket.getSettings();
                        log.debug("HttpDownload, opening channel");
                        try {
                            output = this.prepareDestination(this.ticket.getDestinationSettings());
                            out = new BufferedOutputStream(new FileOutputStream(output));
                        }
                        catch (IOException e) {
                            log.warn("Unable to create destination file.", (Throwable)e);
                            throw new ManagedException("Cannot save file in host");
                        }
                        log.debug("Opening read buffer " + options.getSource().toString());
                        this.ticket.setDestinationFileName(output.getAbsolutePath());
                        try {
                            in = new BufferedInputStream(options.getSource().openStream());
                        }
                        catch (Exception e) {
                            log.debug("Unable to open connection ", (Throwable)e);
                            throw new ManagedException("Cannot open connection to source");
                        }
                        try {
                            long receivedTotal = 0L;
                            byte[] internalBuf = new byte[1024];
                            int received = 0;
                            while ((received = in.read(internalBuf)) != -1) {
                                out.write(internalBuf);
                                this.updateTicket("Transferring", 0.0, TransferTicket.Status.TRANSFERRING, receivedTotal += (long)received);
                            }
                        }
                        catch (IOException e) {
                            log.debug("Unable to read from source", (Throwable)e);
                            throw new ManagedException("Unable to read from source.");
                        }
                        complete = true;
                    }
                    finally {
                        if (!complete && output != null) {
                            Files.deleteIfExists(null);
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    }
                    this.updateTicket("Completed transfer", 1.0, TransferTicket.Status.SUCCESS);
                }
            }
        }
        catch (NotSupportedMethodException e) {
            this.setError(e.getMessage());
        }
        catch (ManagedException e) {
            this.setError(e.getMessage());
        }
        catch (Throwable t) {
            this.setError("Unexpected error while downloading : " + t.getMessage());
            log.error("Unexpected error occurred", t);
        }
    }

    private void setError(String message) {
        this.updateTicket(message, this.ticket.getPercent(), TransferTicket.Status.ERROR);
    }

    private void updateTicket(String message, double percent, TransferTicket.Status status) {
        this.updateTicket(message, percent, status, this.ticket.getTransferredBytes());
    }

    private void updateTicket(String message, double percent, TransferTicket.Status status, long readBytes) {
        this.ticket.setStatus(status);
        this.ticket.setMessage(message);
        this.ticket.setPercent(percent);
        this.ticket.setTransferredBytes(readBytes);
        try {
            long elapsedTime = System.currentTimeMillis() - this.ticket.getSubmissionTime().getValue().getTimeInMillis();
            long average = readBytes / (elapsedTime == 0L ? 1L : elapsedTime) * 1000L;
            this.ticket.setAverageTransferSpeed(average);
        }
        catch (Exception e) {
            log.warn("Unable to evaluate average ", (Throwable)e);
        }
        this.manager.insertUpdate(this.ticket);
    }

    private File prepareDestination(Destination dest) throws DestinationAccessException {
        File destination;
        File persistenceFolder = this.persistenceProvider.getPersistenceFolderById(dest.getPersistenceId());
        if (!persistenceFolder.canWrite()) {
            throw new DestinationAccessException("Cannot write to selecte persistenceFolder [ID :" + dest.getPersistenceId() + "]");
        }
        log.debug("Got Persistence folder ID {}, PATH {}", (Object)persistenceFolder.getAbsolutePath(), (Object)dest.getPersistenceId());
        String subFolderName = dest.getSubFolder();
        File subFolder = persistenceFolder;
        if (subFolderName != null) {
            log.debug("Looking for subFolder : " + subFolder);
            if (subFolderName.startsWith(File.pathSeparator)) {
                throw new DestinationAccessException("SubFolder cannot be absolute.");
            }
            subFolder = new File(persistenceFolder, subFolderName);
            if (subFolder.exists()) {
                if (!subFolder.canRead()) {
                    throw new DestinationAccessException("Cannot write to " + subFolder.getAbsolutePath());
                }
                RequestHandler.manageClash((DestinationClashPolicy)dest.getOnExistingSubFolder(), (File)subFolder);
            } else if (dest.getCreateSubfolders().booleanValue()) {
                subFolder.mkdirs();
            } else {
                throw new DestinationAccessException("SubFolder not found. Use createSubFolders=true to create it.");
            }
        }
        if ((destination = new File(subFolder, dest.getDestinationFileName())).exists()) {
            return RequestHandler.manageClash((DestinationClashPolicy)dest.getOnExistingFileName(), (File)destination);
        }
        try {
            destination.createNewFile();
            return destination;
        }
        catch (IOException e) {
            throw new DestinationAccessException("Unable to create file ", (Throwable)e);
        }
    }

    private static final File manageClash(DestinationClashPolicy policy, File clashing) throws DestinationAccessException {
        log.debug("Managing clash for {}, policy is {} ", (Object)clashing.getAbsolutePath(), (Object)policy);
        boolean dir = clashing.isDirectory();
        try {
            switch (1.$SwitchMap$org$gcube$data$transfer$model$DestinationClashPolicy[policy.ordinal()]) {
                case 1: {
                    int counter = 1;
                    while (clashing.exists()) {
                        clashing = new File(clashing.getParentFile(), clashing.getName() + "(" + counter + ")");
                    }
                    if (dir) {
                        clashing.mkdirs();
                        break;
                    }
                    clashing.createNewFile();
                    break;
                }
                case 2: {
                    throw new DestinationAccessException("Found existing " + clashing.getAbsolutePath() + "policy is " + policy);
                }
                case 3: {
                    Files.deleteIfExists(Paths.get(clashing.getAbsolutePath(), new String[0]));
                    if (dir) {
                        clashing.mkdirs();
                        break;
                    }
                    clashing.createNewFile();
                }
            }
        }
        catch (IOException e) {
            throw new DestinationAccessException("Unable to rewrite existing destination", (Throwable)e);
        }
        return clashing;
    }
}

