/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.gcube.data.transfer.model.options.HttpDownloadOptions;
import org.gcube.data.transfer.service.transfers.engine.CapabilitiesProvider;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;

@Singleton
public class CapabilitiesProviderImpl
implements CapabilitiesProvider {
    private final Object $lock = new Object[0];
    private TransferCapabilities capabilities = null;
    private PersistenceProvider persistenceProvider;
    private PluginManager pluginManager;

    @Inject
    public CapabilitiesProviderImpl(PersistenceProvider persistenceProvider, PluginManager pluginManager) {
        this.persistenceProvider = persistenceProvider;
        this.pluginManager = pluginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferCapabilities get() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.capabilities == null) {
                this.capabilities = this.getCapabilities();
            }
            return this.capabilities;
        }
    }

    private TransferCapabilities getCapabilities() {
        ApplicationContext context = ContextProvider.get();
        ContainerConfiguration configuration = context.container().configuration();
        String hostName = configuration.hostname();
        String id = ((GCoreEndpoint)context.profile(GCoreEndpoint.class)).id();
        Integer port = configuration.port();
        HashSet<HttpDownloadOptions> meansOfTransfer = new HashSet<HttpDownloadOptions>();
        meansOfTransfer.add(HttpDownloadOptions.DEFAULT);
        HashSet plugins = new HashSet(this.pluginManager.getInstalledPlugins().values());
        return new TransferCapabilities(id, hostName, port, meansOfTransfer, plugins, this.persistenceProvider.getAvaileblContextIds());
    }
}

