/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.DeletionReport;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.faults.DestinationAccessException;
import org.gcube.data.transfer.service.transfers.engine.impl.PersistenceProviderImpl;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class PersistenceProviderImpl
implements PersistenceProvider {
    private static final Logger log = LoggerFactory.getLogger(PersistenceProviderImpl.class);

    public File getPersistedFile(String persistenceId, String subPath) throws DestinationAccessException {
        log.debug("Accessing <{}>/{}", (Object)persistenceId, (Object)subPath);
        File persistenceFolder = this.getPersistenceFolderById(persistenceId);
        return new File(persistenceFolder.getAbsolutePath() + "/" + subPath);
    }

    public RemoteFileDescriptor getDescriptor(String persistenceId, String subPath) throws DestinationAccessException {
        File file = this.getPersistedFile(persistenceId, subPath);
        log.debug("Getting descriptor for {} ", (Object)file.getAbsolutePath());
        if (!file.exists()) {
            throw new DestinationAccessException("Unable to find " + file.getAbsolutePath());
        }
        RemoteFileDescriptor toReturn = new RemoteFileDescriptor();
        try {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            toReturn.setCreationDate(attributes.creationTime().toMillis());
            toReturn.setLastUpdate(attributes.lastModifiedTime().toMillis());
            toReturn.setSize(attributes.size());
        }
        catch (Throwable t) {
            log.warn("Unable to access attributes for {} ", (Object)file.getAbsolutePath(), (Object)t);
        }
        toReturn.setAbsolutePath(file.getAbsolutePath());
        toReturn.setDirectory(file.isDirectory());
        toReturn.setFilename(file.getName());
        toReturn.setPersistenceId(persistenceId);
        toReturn.setPath(subPath);
        log.debug("Returning descriptor {} ", (Object)toReturn);
        return toReturn;
    }

    public File getPersistenceFolderById(String persistenceId) throws DestinationAccessException {
        File toReturn = null;
        log.debug("looking for persistence ID : {}", (Object)persistenceId);
        if (persistenceId.equalsIgnoreCase("DEFAULT")) {
            log.debug("Persistence ID is default");
            ApplicationContext context = ContextProvider.get();
            toReturn = new File(context.persistence().location());
        } else {
            for (ApplicationConfiguration config : ContextProvider.get().container().configuration().apps()) {
                if (!config.context().equals(persistenceId) && !config.context().equals("/" + persistenceId)) continue;
                log.debug("Found persistence ID {}", (Object)persistenceId);
                toReturn = new File(config.persistence().location());
                break;
            }
        }
        if (toReturn == null) {
            throw new DestinationAccessException("Persistence ID " + persistenceId + " not found.");
        }
        if (!toReturn.exists()) {
            throw new DestinationAccessException("Persistence ID " + persistenceId + ", location " + toReturn.getAbsolutePath() + " location doesn't exists.");
        }
        if (!toReturn.canWrite()) {
            throw new DestinationAccessException("Cannot write to Persistence ID " + persistenceId + ", location " + toReturn.getAbsolutePath() + " .");
        }
        if (!toReturn.isDirectory()) {
            throw new DestinationAccessException("Persistence ID " + persistenceId + ", location " + toReturn.getAbsolutePath() + " is a directory.");
        }
        if (!toReturn.canWrite()) {
            throw new DestinationAccessException("Cannot write to Persistence ID " + persistenceId + ", location " + toReturn.getAbsolutePath() + " .");
        }
        return toReturn;
    }

    public Set<String> getAvaileblContextIds() {
        HashSet<String> toReturn = new HashSet<String>();
        for (ApplicationConfiguration config : ContextProvider.get().container().configuration().apps()) {
            String toAddID = config.context();
            if (toAddID.startsWith("/")) {
                toAddID = toAddID.substring(1);
            }
            toReturn.add(toAddID);
        }
        return toReturn;
    }

    public File prepareDestination(Destination dest) throws DestinationAccessException {
        File destination;
        File persistenceFolder = this.getPersistenceFolderById(dest.getPersistenceId());
        if (!persistenceFolder.canWrite()) {
            throw new DestinationAccessException("Cannot write to selecte persistenceFolder [ID :" + dest.getPersistenceId() + "]");
        }
        log.debug("Got Persistence folder PATH {}, ID {}", (Object)persistenceFolder.getAbsolutePath(), (Object)dest.getPersistenceId());
        String subFolderName = dest.getSubFolder();
        File subFolder = persistenceFolder;
        if (subFolderName != null) {
            log.debug("Looking for subFolder : " + subFolder);
            if (subFolderName.startsWith(File.pathSeparator)) {
                throw new DestinationAccessException("SubFolder cannot be absolute.");
            }
            subFolder = new File(persistenceFolder, subFolderName);
            if (subFolder.exists()) {
                if (!subFolder.canRead()) {
                    throw new DestinationAccessException("Cannot write to " + subFolder.getAbsolutePath());
                }
                PersistenceProviderImpl.manageClash((DestinationClashPolicy)dest.getOnExistingSubFolder(), (File)subFolder);
            } else if (dest.getCreateSubfolders().booleanValue()) {
                subFolder.mkdirs();
            } else {
                throw new DestinationAccessException("SubFolder not found. Use createSubFolders=true to create it.");
            }
        }
        if ((destination = new File(subFolder, dest.getDestinationFileName())).exists()) {
            return PersistenceProviderImpl.manageClash((DestinationClashPolicy)dest.getOnExistingFileName(), (File)destination);
        }
        try {
            destination.createNewFile();
            return destination;
        }
        catch (IOException e) {
            throw new DestinationAccessException("Unable to create file " + destination.getAbsolutePath(), (Throwable)e);
        }
    }

    public static final File manageClash(DestinationClashPolicy policy, File clashing) throws DestinationAccessException {
        log.debug("Managing clash for {}, policy is {} ", (Object)clashing.getAbsolutePath(), (Object)policy);
        boolean dir = clashing.isDirectory();
        try {
            switch (1.$SwitchMap$org$gcube$data$transfer$model$DestinationClashPolicy[policy.ordinal()]) {
                case 1: {
                    String clashingName = clashing.getName();
                    String clashingBaseName = !dir && clashingName.contains(".") ? clashingName.substring(0, clashingName.lastIndexOf(".")) : clashingName;
                    String destinationExtension = !dir && clashingName.contains(".") ? clashingName.substring(clashingName.lastIndexOf(".")) : "";
                    int counter = 1;
                    while (clashing.exists()) {
                        clashing = new File(clashing.getParentFile(), clashingBaseName + "(" + counter + ")" + destinationExtension);
                        ++counter;
                    }
                    if (dir) {
                        clashing.mkdirs();
                        break;
                    }
                    clashing.createNewFile();
                    break;
                }
                case 2: {
                    throw new DestinationAccessException("Found existing " + clashing.getAbsolutePath() + "policy is " + policy);
                }
                case 3: {
                    PersistenceProviderImpl.deleteRecursively((File)clashing);
                    if (dir) {
                        clashing.mkdirs();
                        break;
                    }
                    clashing.createNewFile();
                }
            }
        }
        catch (IOException e) {
            throw new DestinationAccessException("Unable to rewrite existing destination", (Throwable)e);
        }
        return clashing;
    }

    public DeletionReport delete(String persistenceId, String subPath) throws DestinationAccessException {
        String toDeletePublicPath = persistenceId + "/" + subPath;
        File toDelete = this.getPersistedFile(persistenceId, subPath);
        try {
            log.warn("Going to DELETE {} aka {} ", (Object)toDelete.getAbsolutePath(), (Object)toDeletePublicPath);
            PersistenceProviderImpl.deleteRecursively((File)toDelete);
            return new DeletionReport(toDeletePublicPath, toDelete.getAbsolutePath());
        }
        catch (Throwable t) {
            throw new DestinationAccessException("Unable to delete " + toDeletePublicPath, t);
        }
    }

    public static final void deleteRecursively(File toDelete) throws IOException {
        log.warn("Recursively deleting {} ", (Object)toDelete.getAbsolutePath());
        if (toDelete.isDirectory()) {
            for (File child : toDelete.listFiles()) {
                PersistenceProviderImpl.deleteRecursively((File)child);
            }
        } else {
            Files.deleteIfExists(toDelete.toPath());
        }
    }
}

