/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.settings.FileUploadSettings;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.service.transfers.engine.AccountingManager;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.faults.ManagedException;
import org.gcube.data.transfer.service.transfers.engine.impl.AbstractTicketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractTicketHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractTicketHandler.class);
    private TransferTicket ticket;
    PersistenceProvider persistenceProvider;
    PluginManager pluginManager;
    private MessageDigest md;
    private AccountingDetails currentAccountingDetails = new AccountingDetails(this, null);

    public AbstractTicketHandler(PersistenceProvider persProv, PluginManager plugMan, TransferTicket ticket, String accountingId) {
        this.persistenceProvider = persProv;
        this.pluginManager = plugMan;
        this.ticket = ticket;
        this.currentAccountingDetails.setAccountingId(accountingId);
        try {
            this.md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize", e);
        }
    }

    protected void onStep(String msg, double progress, TransferTicket.Status status, long transferredBytes) {
        this.ticket.setStatus(status);
        this.ticket.setMessage(msg);
        this.ticket.setPercent(progress);
        this.ticket.setTransferredBytes(transferredBytes);
        try {
            long elapsedTime = System.currentTimeMillis() - this.ticket.getSubmissionTime().getValue().getTimeInMillis();
            long average = transferredBytes / (elapsedTime == 0L ? 1L : elapsedTime) * 1000L;
            this.ticket.setAverageTransferSpeed(average);
        }
        catch (Exception e) {
            log.warn("Unable to evaluate average ", (Throwable)e);
        }
    }

    protected void onError(String message) {
        this.onStep(message, this.ticket.getPercent(), TransferTicket.Status.ERROR);
        this.currentAccountingDetails.setSuccess(false);
    }

    protected void onStep(String msg, double progress, TransferTicket.Status status) {
        this.onStep(msg, progress, status, this.ticket.getTransferredBytes());
    }

    protected void addExecutionReport(ExecutionReport toAdd) {
        if (this.ticket.getExecutionReports() == null) {
            this.ticket.setExecutionReports(new HashMap());
        }
        this.ticket.getExecutionReports().put(toAdd.getInvocation().getPluginId(), toAdd);
        this.onStep(this.ticket.getMessage(), this.ticket.getPercent(), this.ticket.getStatus());
    }

    public TransferTicket getTicket() {
        return this.ticket;
    }

    /*
     * Exception decompiling
     */
    public TransferTicket handle() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String transferStream(InputStream in, OutputStream out) throws ManagedException {
        this.md.reset();
        long receivedTotal = 0L;
        try {
            byte[] internalBuf = new byte[1024];
            int received = 0;
            while ((received = in.read(internalBuf)) != -1) {
                this.md.update(internalBuf, 0, received);
                out.write(internalBuf, 0, received);
                this.onStep("Transferring", 0.0, TransferTicket.Status.TRANSFERRING, receivedTotal += (long)received);
            }
            out.flush();
            byte[] mdbytes = this.md.digest();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            log.debug("Completed transfer phase for ticket ID {}. Transferred {} bytes. ", (Object)this.ticket.getId(), (Object)receivedTotal);
            return sb.toString();
        }
        catch (IOException e) {
            log.debug("Unable to read from source", (Throwable)e);
            throw new ManagedException("Unable to read from source.");
        }
    }

    private void account(AccountingDetails toAccount) {
        AccountingManager manager = AccountingManager.get();
        String accountingId = toAccount.getAccountingId();
        manager.setMimeType(accountingId, toAccount.getMimeType());
        manager.setResourceURI(accountingId, toAccount.getUri());
        manager.setSuccessful(accountingId, toAccount.isSuccess());
        manager.setVolumne(accountingId, toAccount.getVolume());
        if (toAccount.isUpdatedFile()) {
            manager.setUpdate(accountingId);
        } else {
            manager.setCreate(accountingId);
        }
        manager.account(accountingId);
    }

    private InputStream getInputStream() throws ManagedException {
        switch (1.$SwitchMap$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod[this.ticket.getSettings().getOptions().getMethod().ordinal()]) {
            case 1: {
                try {
                    HttpDownloadSettings options = (HttpDownloadSettings)this.ticket.getSettings();
                    String sourceUrl = AbstractTicketHandler.resolveRedirects((String)options.getSource().toString());
                    return new BufferedInputStream(new URL(sourceUrl).openStream());
                }
                catch (Exception e) {
                    log.debug("Unable to open connection ", (Throwable)e);
                    throw new ManagedException("Cannot open connection to source");
                }
            }
            case 2: {
                try {
                    FileUploadSettings options = (FileUploadSettings)this.ticket.getSettings();
                    return new BufferedInputStream(options.getPassedStream());
                }
                catch (Exception e) {
                    log.debug("Unable to open connection ", (Throwable)e);
                    throw new ManagedException("Cannot open connection to source");
                }
            }
        }
        throw new ManagedException(this.ticket.getSettings().getOptions().getMethod() + " cannot be managed");
    }

    private static final void setDestinationFileName(TransferTicket ticket) {
        switch (1.$SwitchMap$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod[ticket.getSettings().getOptions().getMethod().ordinal()]) {
            case 1: {
                HttpDownloadSettings options = (HttpDownloadSettings)ticket.getSettings();
                String toSetFilename = AbstractTicketHandler.retrieveFileName((String)options.getSource().toString(), (String)ticket.getId());
                ticket.getDestinationSettings().setDestinationFileName(toSetFilename);
                break;
            }
            default: {
                ticket.getDestinationSettings().setDestinationFileName(ticket.getId());
            }
        }
        log.info("Set filename in ticket {} ", (Object)ticket);
    }

    private static String resolveRedirects(String url) throws IOException {
        log.debug("Resolving redirect for url {} ", (Object)url);
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        int status = connection.getResponseCode();
        if (status >= 300 && status < 400) {
            String newUrl = connection.getHeaderField("Location");
            log.debug("Following redirect from {} to {} ", (Object)url, (Object)newUrl);
            return AbstractTicketHandler.resolveRedirects((String)newUrl);
        }
        return url;
    }

    private static String retrieveFileName(String url, String defaultName) {
        try {
            String fileName = null;
            log.debug("Resolving name for url {} ", (Object)url);
            url = AbstractTicketHandler.resolveRedirects((String)url);
            URL urlObj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            String contentDisposition = connection.getHeaderField("Content-Disposition");
            Pattern regex = Pattern.compile("(?<=filename=\").*?(?=\")");
            Matcher regexMatcher = regex.matcher(contentDisposition);
            if (regexMatcher.find()) {
                fileName = regexMatcher.group();
            }
            if (fileName == null || fileName.isEmpty()) {
                throw new Exception("Filename was null or empty.");
            }
            return fileName;
        }
        catch (Throwable t) {
            log.debug("Unable to retrieve name from url {}, reverting to default {}.", new Object[]{url, defaultName, t});
            return defaultName;
        }
    }
}

