package org.gcube.datatransfer.scheduler.library.obj;


import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageManagerDetails;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageType;

import com.thoughtworks.xstream.XStream;

public class SchedulerObj implements Serializable{
	private static final long serialVersionUID = 1L;
	//------------------------

	public TypeOfSchedule typeOfSchedule;
	public String typeOfTransfer;
	public String scope;

	public boolean unzipFile;
	public boolean overwrite;
	public boolean syncOp;

	public String agentHostname;

	//source
	public String[] inputUrls;
	public String dataSourceId;

	//destination
	public String destinationFolder;
	public StorageType storageType ;
	public StorageManagerDetails smDetails;

	protected static XStream xstream = new XStream();

	public SchedulerObj(){
		this.typeOfSchedule=null;
		this.typeOfTransfer=null;
		this.scope=null;
		this.unzipFile=false;
		this.overwrite=false;
		this.syncOp=false;
		this.inputUrls=null;
		this.dataSourceId=null;
		this.destinationFolder=null;
		this.storageType=null;
		this.smDetails=null;
	}

	public String toXML(){
		return xstream.toXML(this);
	}
	
	public TypeOfSchedule getTypeOfSchedule() {
		return typeOfSchedule;
	}
	public void setTypeOfSchedule(TypeOfSchedule typeOfSchedule) {
		this.typeOfSchedule = typeOfSchedule;
	}
	public String getTypeOfTransfer() {
		return typeOfTransfer;
	}
	public void setTypeOfTransfer(String typeOfTransfer) {
		this.typeOfTransfer = typeOfTransfer;
	}
	public String getScope() {
		return scope;
	}
	public void setScope(String scope) {
		this.scope = scope;
	}
	public boolean isUnzipFile() {
		return unzipFile;
	}
	public void setUnzipFile(boolean unzipFile) {
		this.unzipFile = unzipFile;
	}
	public boolean isOverwrite() {
		return overwrite;
	}
	public void setOverwrite(boolean overwrite) {
		this.overwrite = overwrite;
	}
	public boolean isSyncOp() {
		return syncOp;
	}
	public void setSyncOp(boolean syncOp) {
		this.syncOp = syncOp;
	}
	public String getAgentHostname() {
		return agentHostname;
	}
	public void setAgentHostname(String agentHostname) {
		this.agentHostname = agentHostname;
	}

	public String[] getInputUrls() {
		return inputUrls;
	}

	public void setInputUrls(String[] inputUrls) {
		this.inputUrls = inputUrls;
	}

	public String getDataSourceId() {
		return dataSourceId;
	}
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = dataSourceId;
	}


	public String getDestinationFolder() {
		return destinationFolder;
	}

	public void setDestinationFolder(String destinationFolder) {
		this.destinationFolder = destinationFolder;
	}

	public StorageType getStorageType() {
		return storageType;
	}
	public void setStorageType(StorageType storageType) {
		this.storageType = storageType;
	}
	public StorageManagerDetails getSmDetails() {
		return smDetails;
	}
	public void setSmDetails(StorageManagerDetails smDetails) {
		this.smDetails = smDetails;
	}

}
