package org.gcube.datatransfer.scheduler.library.proxies;


import org.gcube.common.clients.gcore.builders.StatefulBuilder;
import org.gcube.common.clients.gcore.builders.StatefulBuilderImpl;
import org.gcube.common.clients.gcore.builders.StatelessBuilder;
import org.gcube.common.clients.gcore.builders.StatelessBuilderImpl;
import org.gcube.common.clients.gcore.queries.StatefulQuery;
import org.gcube.common.clients.gcore.queries.StatelessQuery;
import org.gcube.datatransfer.scheduler.library.BinderLibrary;
import org.gcube.datatransfer.scheduler.library.ManagementLibrary;
import org.gcube.datatransfer.scheduler.library.SchedulerLibrary;
import org.gcube.datatransfer.scheduler.library.plugins.BinderServicePlugin;
import org.gcube.datatransfer.scheduler.library.plugins.ManagementServicePlugin;
import org.gcube.datatransfer.scheduler.library.plugins.SchedulerServicePlugin;
import org.gcube.datatransfer.scheduler.library.utils.Constants;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FactoryPortType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.ManagementPortType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SchedulerPortType;



public class Proxies {
	
	private static final SchedulerServicePlugin schedulerPlugin = new SchedulerServicePlugin();
	private static final ManagementServicePlugin managementPlugin = new ManagementServicePlugin();
	private static final BinderServicePlugin binderPlugin = new BinderServicePlugin();

	//scheduler service
	public static StatefulBuilder<SchedulerLibrary> transferScheduler() {
	    return new StatefulBuilderImpl<SchedulerPortType, SchedulerLibrary>(schedulerPlugin);
	}
	
	//management service
	public static StatelessBuilder<ManagementLibrary> transferSchedulerManagement() {
		//return new StatelessBuilderImpl<ManagementPortType, ManagementLibrary>(managementPlugin, managementInstance());
		return new StatelessBuilderImpl<ManagementPortType, ManagementLibrary>(managementPlugin);
	}
	
	//factory
	public static StatelessBuilder<BinderLibrary> transferSchedulerBinder() {
		//return new StatelessBuilderImpl<FactoryPortType, BinderLibrary>(binderPlugin,binderInstance());
	    return new StatelessBuilderImpl<FactoryPortType, BinderLibrary>(binderPlugin);
	}

	public static StatefulQuery schedulerInstance(){
		StatefulQuery query = new StatefulQuery(schedulerPlugin);
	    query.addCondition("//ServiceName",Constants.SERVICE_NAME);
	    query.addCondition("//ServiceClass",Constants.SERVICE_CLASS);
	    return query;
	}
	public static StatelessQuery managementInstance() {
		StatelessQuery query = new StatelessQuery(managementPlugin);
	    query.addCondition("//ServiceName",Constants.SERVICE_NAME);
	    query.addCondition("//ServiceClass",Constants.SERVICE_CLASS);
	    return query;
	}
	public static StatelessQuery binderInstance() {
		StatelessQuery query = new StatelessQuery(binderPlugin);
	    query.addCondition("//ServiceName",Constants.SERVICE_NAME);
	    query.addCondition("//ServiceClass",Constants.SERVICE_CLASS);
	    return query;
	}
	
}
