package org.gcube.datatransfer.scheduler.library.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.datatransfer.scheduler.library.BinderLibrary;
import org.gcube.datatransfer.scheduler.library.utils.Constants;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FactoryPortType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.service.FactoryServiceAddressingLocator;

public class BinderServicePlugin extends BinderAbstractPlugin<FactoryPortType,BinderLibrary> {

	public BinderServicePlugin() {
		super(Constants.FACTORY_PORT_TYPE_NAME);
	}

	public FactoryPortType resolve(EndpointReferenceType address,ProxyConfig<?,?> config) throws Exception {
		return new FactoryServiceAddressingLocator().getFactoryPortTypePort(address);
	}
	
	@Override
	public BinderLibrary newProxy(ProxyDelegate<FactoryPortType> delegate) {
		return new BinderLibrary(delegate);
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> arg1) {
		//if (fault instanceof GCUBEFault)
		//	return new Exception();
		//if (fault instanceof TransferFault)
		//	return new TransferException();
		//if (fault instanceof CancelTransferFault)
		//	return new CancelTransferException();
		//if (fault instanceof MonitorTransferFault)
		//	return new MonitorTransferException();
		//if (fault instanceof GetTransferOutcomesFault)
		//	return new GetTransferOutcomesException();
		
		return new Exception(fault);
	}


}